// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about the topic rule destination.
 */
class TopicRuleDestinationSummary private constructor(builder: Builder) {
    /**
     * The topic rule destination ARN.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * The date and time when the topic rule destination was created.
     */
    val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * Information about the HTTP URL.
     */
    val httpUrlSummary: aws.sdk.kotlin.services.iot.model.HttpUrlDestinationSummary? = builder.httpUrlSummary
    /**
     * The date and time when the topic rule destination was last updated.
     */
    val lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedAt
    /**
     * The status of the topic rule destination. Valid values are:
     * IN_PROGRESS
     * A topic rule destination was created but has not been confirmed. You can set
     * status to IN_PROGRESS by calling
     * UpdateTopicRuleDestination. Calling
     * UpdateTopicRuleDestination causes a new confirmation challenge to
     * be sent to your confirmation endpoint.
     * ENABLED
     * Confirmation was completed, and traffic to this destination is allowed. You can
     * set status to DISABLED by calling
     * UpdateTopicRuleDestination.
     * DISABLED
     * Confirmation was completed, and traffic to this destination is not allowed. You
     * can set status to ENABLED by calling
     * UpdateTopicRuleDestination.
     * ERROR
     * Confirmation could not be completed, for example if the confirmation timed out.
     * You can call GetTopicRuleDestination for details about the error. You
     * can set status to IN_PROGRESS by calling
     * UpdateTopicRuleDestination. Calling
     * UpdateTopicRuleDestination causes a new confirmation challenge to
     * be sent to your confirmation endpoint.
     */
    val status: aws.sdk.kotlin.services.iot.model.TopicRuleDestinationStatus? = builder.status
    /**
     * The reason the topic rule destination is in the current status.
     */
    val statusReason: kotlin.String? = builder.statusReason
    /**
     * Information about the virtual private cloud (VPC) connection.
     */
    val vpcDestinationSummary: aws.sdk.kotlin.services.iot.model.VpcDestinationSummary? = builder.vpcDestinationSummary

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iot.model.TopicRuleDestinationSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TopicRuleDestinationSummary(")
        append("arn=$arn,")
        append("createdAt=$createdAt,")
        append("httpUrlSummary=$httpUrlSummary,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("status=$status,")
        append("statusReason=$statusReason,")
        append("vpcDestinationSummary=$vpcDestinationSummary)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (httpUrlSummary?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        result = 31 * result + (vpcDestinationSummary?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TopicRuleDestinationSummary

        if (arn != other.arn) return false
        if (createdAt != other.createdAt) return false
        if (httpUrlSummary != other.httpUrlSummary) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false
        if (vpcDestinationSummary != other.vpcDestinationSummary) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iot.model.TopicRuleDestinationSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * The topic rule destination ARN.
         */
        var arn: kotlin.String? = null
        /**
         * The date and time when the topic rule destination was created.
         */
        var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Information about the HTTP URL.
         */
        var httpUrlSummary: aws.sdk.kotlin.services.iot.model.HttpUrlDestinationSummary? = null
        /**
         * The date and time when the topic rule destination was last updated.
         */
        var lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the topic rule destination. Valid values are:
         * IN_PROGRESS
         * A topic rule destination was created but has not been confirmed. You can set
         * status to IN_PROGRESS by calling
         * UpdateTopicRuleDestination. Calling
         * UpdateTopicRuleDestination causes a new confirmation challenge to
         * be sent to your confirmation endpoint.
         * ENABLED
         * Confirmation was completed, and traffic to this destination is allowed. You can
         * set status to DISABLED by calling
         * UpdateTopicRuleDestination.
         * DISABLED
         * Confirmation was completed, and traffic to this destination is not allowed. You
         * can set status to ENABLED by calling
         * UpdateTopicRuleDestination.
         * ERROR
         * Confirmation could not be completed, for example if the confirmation timed out.
         * You can call GetTopicRuleDestination for details about the error. You
         * can set status to IN_PROGRESS by calling
         * UpdateTopicRuleDestination. Calling
         * UpdateTopicRuleDestination causes a new confirmation challenge to
         * be sent to your confirmation endpoint.
         */
        var status: aws.sdk.kotlin.services.iot.model.TopicRuleDestinationStatus? = null
        /**
         * The reason the topic rule destination is in the current status.
         */
        var statusReason: kotlin.String? = null
        /**
         * Information about the virtual private cloud (VPC) connection.
         */
        var vpcDestinationSummary: aws.sdk.kotlin.services.iot.model.VpcDestinationSummary? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iot.model.TopicRuleDestinationSummary) : this() {
            this.arn = x.arn
            this.createdAt = x.createdAt
            this.httpUrlSummary = x.httpUrlSummary
            this.lastUpdatedAt = x.lastUpdatedAt
            this.status = x.status
            this.statusReason = x.statusReason
            this.vpcDestinationSummary = x.vpcDestinationSummary
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iot.model.TopicRuleDestinationSummary = TopicRuleDestinationSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.HttpUrlDestinationSummary] inside the given [block]
         */
        fun httpUrlSummary(block: aws.sdk.kotlin.services.iot.model.HttpUrlDestinationSummary.Builder.() -> kotlin.Unit) {
            this.httpUrlSummary = aws.sdk.kotlin.services.iot.model.HttpUrlDestinationSummary.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iot.model.VpcDestinationSummary] inside the given [block]
         */
        fun vpcDestinationSummary(block: aws.sdk.kotlin.services.iot.model.VpcDestinationSummary.Builder.() -> kotlin.Unit) {
            this.vpcDestinationSummary = aws.sdk.kotlin.services.iot.model.VpcDestinationSummary.invoke(block)
        }
    }
}
