// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iot.model.CreateDynamicThingGroupResponse
import aws.sdk.kotlin.services.iot.model.IotException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateDynamicThingGroupOperationDeserializer: HttpDeserialize<CreateDynamicThingGroupResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateDynamicThingGroupResponse {
        if (!response.status.isSuccess()) {
            throwCreateDynamicThingGroupError(context, response)
        }
        val builder = CreateDynamicThingGroupResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateDynamicThingGroupOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeCreateDynamicThingGroupOperationBody(builder: CreateDynamicThingGroupResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val INDEXNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("indexName"))
    val QUERYSTRING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("queryString"))
    val QUERYVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("queryVersion"))
    val THINGGROUPARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("thingGroupArn"))
    val THINGGROUPID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("thingGroupId"))
    val THINGGROUPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("thingGroupName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(INDEXNAME_DESCRIPTOR)
        field(QUERYSTRING_DESCRIPTOR)
        field(QUERYVERSION_DESCRIPTOR)
        field(THINGGROUPARN_DESCRIPTOR)
        field(THINGGROUPID_DESCRIPTOR)
        field(THINGGROUPNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                INDEXNAME_DESCRIPTOR.index -> builder.indexName = deserializeString()
                QUERYSTRING_DESCRIPTOR.index -> builder.queryString = deserializeString()
                QUERYVERSION_DESCRIPTOR.index -> builder.queryVersion = deserializeString()
                THINGGROUPARN_DESCRIPTOR.index -> builder.thingGroupArn = deserializeString()
                THINGGROUPID_DESCRIPTOR.index -> builder.thingGroupId = deserializeString()
                THINGGROUPNAME_DESCRIPTOR.index -> builder.thingGroupName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwCreateDynamicThingGroupError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IotException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer()
        "InvalidQueryException" -> InvalidQueryExceptionDeserializer()
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer()
        "LimitExceededException" -> LimitExceededExceptionDeserializer()
        "ResourceAlreadyExistsException" -> ResourceAlreadyExistsExceptionDeserializer()
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer()
        "ThrottlingException" -> ThrottlingExceptionDeserializer()
        else -> throw IotException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
