// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.transform

import aws.sdk.kotlin.services.iot.model.AggregationType
import aws.sdk.kotlin.services.iot.model.CreateFleetMetricRequest
import aws.sdk.kotlin.services.iot.model.FleetMetricUnit
import aws.sdk.kotlin.services.iot.model.Tag
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateFleetMetricOperationSerializer: HttpSerialize<CreateFleetMetricRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateFleetMetricRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            val pathSegments = listOf(
                "fleet-metric",
                "${input.metricName}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeCreateFleetMetricOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        builder.headers.setMissing("Content-Type", "application/json")
        return builder
    }
}

private fun serializeCreateFleetMetricOperationBody(context: ExecutionContext, input: CreateFleetMetricRequest): ByteArray {
    val serializer = JsonSerializer()
    val AGGREGATIONFIELD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("aggregationField"))
    val AGGREGATIONTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("aggregationType"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val INDEXNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("indexName"))
    val PERIOD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("period"))
    val QUERYSTRING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("queryString"))
    val QUERYVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("queryVersion"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("tags"))
    val UNIT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("unit"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AGGREGATIONFIELD_DESCRIPTOR)
        field(AGGREGATIONTYPE_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(INDEXNAME_DESCRIPTOR)
        field(PERIOD_DESCRIPTOR)
        field(QUERYSTRING_DESCRIPTOR)
        field(QUERYVERSION_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(UNIT_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.aggregationField?.let { field(AGGREGATIONFIELD_DESCRIPTOR, it) }
        input.aggregationType?.let { field(AGGREGATIONTYPE_DESCRIPTOR, it, ::serializeAggregationTypeDocument) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.indexName?.let { field(INDEXNAME_DESCRIPTOR, it) }
        input.period?.let { field(PERIOD_DESCRIPTOR, it) }
        input.queryString?.let { field(QUERYSTRING_DESCRIPTOR, it) }
        input.queryVersion?.let { field(QUERYVERSION_DESCRIPTOR, it) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
        input.unit?.let { field(UNIT_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
