// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iot.model.CreatePolicyVersionResponse
import aws.sdk.kotlin.services.iot.model.IotException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreatePolicyVersionOperationDeserializer: HttpDeserialize<CreatePolicyVersionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreatePolicyVersionResponse {
        if (!response.status.isSuccess()) {
            throwCreatePolicyVersionError(context, response)
        }
        val builder = CreatePolicyVersionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreatePolicyVersionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeCreatePolicyVersionOperationBody(builder: CreatePolicyVersionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ISDEFAULTVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("isDefaultVersion"))
    val POLICYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("policyArn"))
    val POLICYDOCUMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("policyDocument"))
    val POLICYVERSIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("policyVersionId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ISDEFAULTVERSION_DESCRIPTOR)
        field(POLICYARN_DESCRIPTOR)
        field(POLICYDOCUMENT_DESCRIPTOR)
        field(POLICYVERSIONID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ISDEFAULTVERSION_DESCRIPTOR.index -> builder.isDefaultVersion = deserializeBoolean()
                POLICYARN_DESCRIPTOR.index -> builder.policyArn = deserializeString()
                POLICYDOCUMENT_DESCRIPTOR.index -> builder.policyDocument = deserializeString()
                POLICYVERSIONID_DESCRIPTOR.index -> builder.policyVersionId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwCreatePolicyVersionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IotException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer()
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer()
        "MalformedPolicyException" -> MalformedPolicyExceptionDeserializer()
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer()
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer()
        "ThrottlingException" -> ThrottlingExceptionDeserializer()
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer()
        "VersionsLimitExceededException" -> VersionsLimitExceededExceptionDeserializer()
        else -> throw IotException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
