// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iot.model.CreateProvisioningClaimResponse
import aws.sdk.kotlin.services.iot.model.IotException
import aws.sdk.kotlin.services.iot.model.KeyPair
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class CreateProvisioningClaimOperationDeserializer: HttpDeserialize<CreateProvisioningClaimResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateProvisioningClaimResponse {
        if (!response.status.isSuccess()) {
            throwCreateProvisioningClaimError(context, response)
        }
        val builder = CreateProvisioningClaimResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateProvisioningClaimOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeCreateProvisioningClaimOperationBody(builder: CreateProvisioningClaimResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CERTIFICATEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("certificateId"))
    val CERTIFICATEPEM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("certificatePem"))
    val EXPIRATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("expiration"))
    val KEYPAIR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("keyPair"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CERTIFICATEID_DESCRIPTOR)
        field(CERTIFICATEPEM_DESCRIPTOR)
        field(EXPIRATION_DESCRIPTOR)
        field(KEYPAIR_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CERTIFICATEID_DESCRIPTOR.index -> builder.certificateId = deserializeString()
                CERTIFICATEPEM_DESCRIPTOR.index -> builder.certificatePem = deserializeString()
                EXPIRATION_DESCRIPTOR.index -> builder.expiration = deserializeString().let { Instant.fromEpochSeconds(it) }
                KEYPAIR_DESCRIPTOR.index -> builder.keyPair = deserializeKeyPairDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwCreateProvisioningClaimError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IotException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer()
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer()
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer()
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer()
        "ThrottlingException" -> ThrottlingExceptionDeserializer()
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer()
        else -> throw IotException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
