// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iot.model.DescribeThingResponse
import aws.sdk.kotlin.services.iot.model.IotException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeThingOperationDeserializer: HttpDeserialize<DescribeThingResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeThingResponse {
        if (!response.status.isSuccess()) {
            throwDescribeThingError(context, response)
        }
        val builder = DescribeThingResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeThingOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeDescribeThingOperationBody(builder: DescribeThingResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("attributes"))
    val BILLINGGROUPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("billingGroupName"))
    val DEFAULTCLIENTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("defaultClientId"))
    val THINGARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("thingArn"))
    val THINGID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("thingId"))
    val THINGNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("thingName"))
    val THINGTYPENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("thingTypeName"))
    val VERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("version"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ATTRIBUTES_DESCRIPTOR)
        field(BILLINGGROUPNAME_DESCRIPTOR)
        field(DEFAULTCLIENTID_DESCRIPTOR)
        field(THINGARN_DESCRIPTOR)
        field(THINGID_DESCRIPTOR)
        field(THINGNAME_DESCRIPTOR)
        field(THINGTYPENAME_DESCRIPTOR)
        field(VERSION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ATTRIBUTES_DESCRIPTOR.index -> builder.attributes =
                    deserializer.deserializeMap(ATTRIBUTES_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                BILLINGGROUPNAME_DESCRIPTOR.index -> builder.billingGroupName = deserializeString()
                DEFAULTCLIENTID_DESCRIPTOR.index -> builder.defaultClientId = deserializeString()
                THINGARN_DESCRIPTOR.index -> builder.thingArn = deserializeString()
                THINGID_DESCRIPTOR.index -> builder.thingId = deserializeString()
                THINGNAME_DESCRIPTOR.index -> builder.thingName = deserializeString()
                THINGTYPENAME_DESCRIPTOR.index -> builder.thingTypeName = deserializeString()
                VERSION_DESCRIPTOR.index -> builder.version = deserializeLong()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwDescribeThingError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IotException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer()
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer()
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer()
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer()
        "ThrottlingException" -> ThrottlingExceptionDeserializer()
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer()
        else -> throw IotException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
