// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iot.model.DescribeThingTypeResponse
import aws.sdk.kotlin.services.iot.model.IotException
import aws.sdk.kotlin.services.iot.model.ThingTypeMetadata
import aws.sdk.kotlin.services.iot.model.ThingTypeProperties
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeThingTypeOperationDeserializer: HttpDeserialize<DescribeThingTypeResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeThingTypeResponse {
        if (!response.status.isSuccess()) {
            throwDescribeThingTypeError(context, response)
        }
        val builder = DescribeThingTypeResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeThingTypeOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeDescribeThingTypeOperationBody(builder: DescribeThingTypeResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val THINGTYPEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("thingTypeArn"))
    val THINGTYPEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("thingTypeId"))
    val THINGTYPEMETADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("thingTypeMetadata"))
    val THINGTYPENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("thingTypeName"))
    val THINGTYPEPROPERTIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("thingTypeProperties"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(THINGTYPEARN_DESCRIPTOR)
        field(THINGTYPEID_DESCRIPTOR)
        field(THINGTYPEMETADATA_DESCRIPTOR)
        field(THINGTYPENAME_DESCRIPTOR)
        field(THINGTYPEPROPERTIES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                THINGTYPEARN_DESCRIPTOR.index -> builder.thingTypeArn = deserializeString()
                THINGTYPEID_DESCRIPTOR.index -> builder.thingTypeId = deserializeString()
                THINGTYPEMETADATA_DESCRIPTOR.index -> builder.thingTypeMetadata = deserializeThingTypeMetadataDocument(deserializer)
                THINGTYPENAME_DESCRIPTOR.index -> builder.thingTypeName = deserializeString()
                THINGTYPEPROPERTIES_DESCRIPTOR.index -> builder.thingTypeProperties = deserializeThingTypePropertiesDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwDescribeThingTypeError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IotException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer()
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer()
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer()
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer()
        "ThrottlingException" -> ThrottlingExceptionDeserializer()
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer()
        else -> throw IotException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
