// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iot.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iot.model.IotException
import aws.sdk.kotlin.services.iot.model.RegisterCaCertificateResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class RegisterCACertificateOperationDeserializer: HttpDeserialize<RegisterCaCertificateResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): RegisterCaCertificateResponse {
        if (!response.status.isSuccess()) {
            throwRegisterCaCertificateError(context, response)
        }
        val builder = RegisterCaCertificateResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeRegisterCACertificateOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeRegisterCACertificateOperationBody(builder: RegisterCaCertificateResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CERTIFICATEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("certificateArn"))
    val CERTIFICATEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("certificateId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CERTIFICATEARN_DESCRIPTOR)
        field(CERTIFICATEID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CERTIFICATEARN_DESCRIPTOR.index -> builder.certificateArn = deserializeString()
                CERTIFICATEID_DESCRIPTOR.index -> builder.certificateId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwRegisterCaCertificateError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IotException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "CertificateValidationException" -> CertificateValidationExceptionDeserializer()
        "InternalFailureException" -> InternalFailureExceptionDeserializer()
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer()
        "LimitExceededException" -> LimitExceededExceptionDeserializer()
        "RegistrationCodeValidationException" -> RegistrationCodeValidationExceptionDeserializer()
        "ResourceAlreadyExistsException" -> ResourceAlreadyExistsExceptionDeserializer()
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer()
        "ThrottlingException" -> ThrottlingExceptionDeserializer()
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer()
        else -> throw IotException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
