// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotanalytics.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A summary of information about a channel.
 */
class ChannelSummary private constructor(builder: Builder) {
    /**
     * The name of the channel.
     */
    val channelName: kotlin.String? = builder.channelName
    /**
     * Where channel data is stored.
     */
    val channelStorage: aws.sdk.kotlin.services.iotanalytics.model.ChannelStorageSummary? = builder.channelStorage
    /**
     * When the channel was created.
     */
    val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The last time when a new message arrived in the channel.
     *
     * IoT Analytics updates this value at most once per minute for one channel. Hence, the `lastMessageArrivalTime` value is an approximation.
     *
     * This feature only applies to messages that arrived in the data store after October 23, 2020.
     */
    val lastMessageArrivalTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastMessageArrivalTime
    /**
     * The last time the channel was updated.
     */
    val lastUpdateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdateTime
    /**
     * The status of the channel.
     */
    val status: aws.sdk.kotlin.services.iotanalytics.model.ChannelStatus? = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotanalytics.model.ChannelSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ChannelSummary(")
        append("channelName=$channelName,")
        append("channelStorage=$channelStorage,")
        append("creationTime=$creationTime,")
        append("lastMessageArrivalTime=$lastMessageArrivalTime,")
        append("lastUpdateTime=$lastUpdateTime,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = channelName?.hashCode() ?: 0
        result = 31 * result + (channelStorage?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (lastMessageArrivalTime?.hashCode() ?: 0)
        result = 31 * result + (lastUpdateTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ChannelSummary

        if (channelName != other.channelName) return false
        if (channelStorage != other.channelStorage) return false
        if (creationTime != other.creationTime) return false
        if (lastMessageArrivalTime != other.lastMessageArrivalTime) return false
        if (lastUpdateTime != other.lastUpdateTime) return false
        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotanalytics.model.ChannelSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the channel.
         */
        var channelName: kotlin.String? = null
        /**
         * Where channel data is stored.
         */
        var channelStorage: aws.sdk.kotlin.services.iotanalytics.model.ChannelStorageSummary? = null
        /**
         * When the channel was created.
         */
        var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The last time when a new message arrived in the channel.
         *
         * IoT Analytics updates this value at most once per minute for one channel. Hence, the `lastMessageArrivalTime` value is an approximation.
         *
         * This feature only applies to messages that arrived in the data store after October 23, 2020.
         */
        var lastMessageArrivalTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The last time the channel was updated.
         */
        var lastUpdateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the channel.
         */
        var status: aws.sdk.kotlin.services.iotanalytics.model.ChannelStatus? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotanalytics.model.ChannelSummary) : this() {
            this.channelName = x.channelName
            this.channelStorage = x.channelStorage
            this.creationTime = x.creationTime
            this.lastMessageArrivalTime = x.lastMessageArrivalTime
            this.lastUpdateTime = x.lastUpdateTime
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotanalytics.model.ChannelSummary = ChannelSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotanalytics.model.ChannelStorageSummary] inside the given [block]
         */
        fun channelStorage(block: aws.sdk.kotlin.services.iotanalytics.model.ChannelStorageSummary.Builder.() -> kotlin.Unit) {
            this.channelStorage = aws.sdk.kotlin.services.iotanalytics.model.ChannelStorageSummary.invoke(block)
        }
    }
}
