// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotanalytics.model



/**
 * Information required to run the `containerAction` to produce dataset contents.
 */
class ContainerDatasetAction private constructor(builder: Builder) {
    /**
     * The ARN of the role that gives permission to the system to access required resources to run the `containerAction`. This includes, at minimum, permission to retrieve the dataset contents that are the input to the containerized application.
     */
    val executionRoleArn: kotlin.String? = builder.executionRoleArn
    /**
     * The ARN of the Docker container stored in your account. The Docker container contains an application and required support libraries and is used to generate dataset contents.
     */
    val image: kotlin.String? = builder.image
    /**
     * Configuration of the resource that executes the `containerAction`.
     */
    val resourceConfiguration: aws.sdk.kotlin.services.iotanalytics.model.ResourceConfiguration? = builder.resourceConfiguration
    /**
     * The values of variables used in the context of the execution of the containerized application (basically, parameters passed to the application). Each variable must have a name and a value given by one of `stringValue`, `datasetContentVersionValue`, or `outputFileUriValue`.
     */
    val variables: List<Variable>? = builder.variables

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotanalytics.model.ContainerDatasetAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ContainerDatasetAction(")
        append("executionRoleArn=$executionRoleArn,")
        append("image=$image,")
        append("resourceConfiguration=$resourceConfiguration,")
        append("variables=$variables)")
    }

    override fun hashCode(): kotlin.Int {
        var result = executionRoleArn?.hashCode() ?: 0
        result = 31 * result + (image?.hashCode() ?: 0)
        result = 31 * result + (resourceConfiguration?.hashCode() ?: 0)
        result = 31 * result + (variables?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ContainerDatasetAction

        if (executionRoleArn != other.executionRoleArn) return false
        if (image != other.image) return false
        if (resourceConfiguration != other.resourceConfiguration) return false
        if (variables != other.variables) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotanalytics.model.ContainerDatasetAction = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ARN of the role that gives permission to the system to access required resources to run the `containerAction`. This includes, at minimum, permission to retrieve the dataset contents that are the input to the containerized application.
         */
        var executionRoleArn: kotlin.String? = null
        /**
         * The ARN of the Docker container stored in your account. The Docker container contains an application and required support libraries and is used to generate dataset contents.
         */
        var image: kotlin.String? = null
        /**
         * Configuration of the resource that executes the `containerAction`.
         */
        var resourceConfiguration: aws.sdk.kotlin.services.iotanalytics.model.ResourceConfiguration? = null
        /**
         * The values of variables used in the context of the execution of the containerized application (basically, parameters passed to the application). Each variable must have a name and a value given by one of `stringValue`, `datasetContentVersionValue`, or `outputFileUriValue`.
         */
        var variables: List<Variable>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotanalytics.model.ContainerDatasetAction) : this() {
            this.executionRoleArn = x.executionRoleArn
            this.image = x.image
            this.resourceConfiguration = x.resourceConfiguration
            this.variables = x.variables
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotanalytics.model.ContainerDatasetAction = ContainerDatasetAction(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotanalytics.model.ResourceConfiguration] inside the given [block]
         */
        fun resourceConfiguration(block: aws.sdk.kotlin.services.iotanalytics.model.ResourceConfiguration.Builder.() -> kotlin.Unit) {
            this.resourceConfiguration = aws.sdk.kotlin.services.iotanalytics.model.ResourceConfiguration.invoke(block)
        }
    }
}
