// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotanalytics.model



/**
 * Configuration information for delivery of dataset contents to Amazon Simple Storage Service (Amazon S3).
 */
class S3DestinationConfiguration private constructor(builder: Builder) {
    /**
     * The name of the S3 bucket to which dataset contents are delivered.
     */
    val bucket: kotlin.String? = builder.bucket
    /**
     * Configuration information for coordination with Glue, a fully managed extract, transform and load (ETL) service.
     */
    val glueConfiguration: aws.sdk.kotlin.services.iotanalytics.model.GlueConfiguration? = builder.glueConfiguration
    /**
     * The key of the dataset contents object in an S3 bucket. Each object has a key that is a unique identifier. Each object has exactly one key.
     *
     * You can create a unique key with the following options:
     * + Use `!{iotanalytics:scheduleTime}` to insert the time of a scheduled SQL query run.
     * + Use `!{iotanalytics:versionId}` to insert a unique hash that identifies a dataset content.
     * + Use `!{iotanalytics:creationTime}` to insert the creation time of a dataset content.
     *
     * The following example creates a unique key for a CSV file: `dataset/mydataset/!{iotanalytics:scheduleTime}/!{iotanalytics:versionId}.csv`
     *
     * If you don't use `!{iotanalytics:versionId}` to specify the key, you might get duplicate keys. For example, you might have two dataset contents with the same `scheduleTime` but different `versionId`s. This means that one dataset content overwrites the other.
     */
    val key: kotlin.String? = builder.key
    /**
     * The ARN of the role that grants IoT Analytics permission to interact with your Amazon S3 and Glue resources.
     */
    val roleArn: kotlin.String? = builder.roleArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotanalytics.model.S3DestinationConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3DestinationConfiguration(")
        append("bucket=$bucket,")
        append("glueConfiguration=$glueConfiguration,")
        append("key=$key,")
        append("roleArn=$roleArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket?.hashCode() ?: 0
        result = 31 * result + (glueConfiguration?.hashCode() ?: 0)
        result = 31 * result + (key?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3DestinationConfiguration

        if (bucket != other.bucket) return false
        if (glueConfiguration != other.glueConfiguration) return false
        if (key != other.key) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotanalytics.model.S3DestinationConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the S3 bucket to which dataset contents are delivered.
         */
        var bucket: kotlin.String? = null
        /**
         * Configuration information for coordination with Glue, a fully managed extract, transform and load (ETL) service.
         */
        var glueConfiguration: aws.sdk.kotlin.services.iotanalytics.model.GlueConfiguration? = null
        /**
         * The key of the dataset contents object in an S3 bucket. Each object has a key that is a unique identifier. Each object has exactly one key.
         *
         * You can create a unique key with the following options:
         * + Use `!{iotanalytics:scheduleTime}` to insert the time of a scheduled SQL query run.
         * + Use `!{iotanalytics:versionId}` to insert a unique hash that identifies a dataset content.
         * + Use `!{iotanalytics:creationTime}` to insert the creation time of a dataset content.
         *
         * The following example creates a unique key for a CSV file: `dataset/mydataset/!{iotanalytics:scheduleTime}/!{iotanalytics:versionId}.csv`
         *
         * If you don't use `!{iotanalytics:versionId}` to specify the key, you might get duplicate keys. For example, you might have two dataset contents with the same `scheduleTime` but different `versionId`s. This means that one dataset content overwrites the other.
         */
        var key: kotlin.String? = null
        /**
         * The ARN of the role that grants IoT Analytics permission to interact with your Amazon S3 and Glue resources.
         */
        var roleArn: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotanalytics.model.S3DestinationConfiguration) : this() {
            this.bucket = x.bucket
            this.glueConfiguration = x.glueConfiguration
            this.key = x.key
            this.roleArn = x.roleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotanalytics.model.S3DestinationConfiguration = S3DestinationConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotanalytics.model.GlueConfiguration] inside the given [block]
         */
        fun glueConfiguration(block: aws.sdk.kotlin.services.iotanalytics.model.GlueConfiguration.Builder.() -> kotlin.Unit) {
            this.glueConfiguration = aws.sdk.kotlin.services.iotanalytics.model.GlueConfiguration.invoke(block)
        }
    }
}
