// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotanalytics.model



class UpdateDatasetRequest private constructor(builder: Builder) {
    /**
     * A list of `DatasetAction` objects.
     */
    val actions: List<DatasetAction>? = builder.actions
    /**
     * When dataset contents are created, they are delivered to destinations specified here.
     */
    val contentDeliveryRules: List<DatasetContentDeliveryRule>? = builder.contentDeliveryRules
    /**
     * The name of the dataset to update.
     */
    val datasetName: kotlin.String? = requireNotNull(builder.datasetName) { "A non-null value must be provided for datasetName" }
    /**
     * A list of data rules that send notifications to CloudWatch, when data arrives late. To specify `lateDataRules`, the dataset must use a [DeltaTimer](https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_DeltaTime.html) filter.
     */
    val lateDataRules: List<LateDataRule>? = builder.lateDataRules
    /**
     * How long, in days, dataset contents are kept for the dataset.
     */
    val retentionPeriod: aws.sdk.kotlin.services.iotanalytics.model.RetentionPeriod? = builder.retentionPeriod
    /**
     * A list of `DatasetTrigger` objects. The list can be empty or can contain up to five `DatasetTrigger` objects.
     */
    val triggers: List<DatasetTrigger>? = builder.triggers
    /**
     * Optional. How many versions of dataset contents are kept. If not specified or set to null, only the latest version plus the latest succeeded version (if they are different) are kept for the time period specified by the `retentionPeriod` parameter. For more information, see [Keeping Multiple Versions of IoT Analytics datasets](https://docs.aws.amazon.com/iotanalytics/latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions) in the *IoT Analytics User Guide*.
     */
    val versioningConfiguration: aws.sdk.kotlin.services.iotanalytics.model.VersioningConfiguration? = builder.versioningConfiguration

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotanalytics.model.UpdateDatasetRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateDatasetRequest(")
        append("actions=$actions,")
        append("contentDeliveryRules=$contentDeliveryRules,")
        append("datasetName=$datasetName,")
        append("lateDataRules=$lateDataRules,")
        append("retentionPeriod=$retentionPeriod,")
        append("triggers=$triggers,")
        append("versioningConfiguration=$versioningConfiguration)")
    }

    override fun hashCode(): kotlin.Int {
        var result = actions?.hashCode() ?: 0
        result = 31 * result + (contentDeliveryRules?.hashCode() ?: 0)
        result = 31 * result + (datasetName?.hashCode() ?: 0)
        result = 31 * result + (lateDataRules?.hashCode() ?: 0)
        result = 31 * result + (retentionPeriod?.hashCode() ?: 0)
        result = 31 * result + (triggers?.hashCode() ?: 0)
        result = 31 * result + (versioningConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateDatasetRequest

        if (actions != other.actions) return false
        if (contentDeliveryRules != other.contentDeliveryRules) return false
        if (datasetName != other.datasetName) return false
        if (lateDataRules != other.lateDataRules) return false
        if (retentionPeriod != other.retentionPeriod) return false
        if (triggers != other.triggers) return false
        if (versioningConfiguration != other.versioningConfiguration) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotanalytics.model.UpdateDatasetRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A list of `DatasetAction` objects.
         */
        var actions: List<DatasetAction>? = null
        /**
         * When dataset contents are created, they are delivered to destinations specified here.
         */
        var contentDeliveryRules: List<DatasetContentDeliveryRule>? = null
        /**
         * The name of the dataset to update.
         */
        var datasetName: kotlin.String? = null
        /**
         * A list of data rules that send notifications to CloudWatch, when data arrives late. To specify `lateDataRules`, the dataset must use a [DeltaTimer](https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_DeltaTime.html) filter.
         */
        var lateDataRules: List<LateDataRule>? = null
        /**
         * How long, in days, dataset contents are kept for the dataset.
         */
        var retentionPeriod: aws.sdk.kotlin.services.iotanalytics.model.RetentionPeriod? = null
        /**
         * A list of `DatasetTrigger` objects. The list can be empty or can contain up to five `DatasetTrigger` objects.
         */
        var triggers: List<DatasetTrigger>? = null
        /**
         * Optional. How many versions of dataset contents are kept. If not specified or set to null, only the latest version plus the latest succeeded version (if they are different) are kept for the time period specified by the `retentionPeriod` parameter. For more information, see [Keeping Multiple Versions of IoT Analytics datasets](https://docs.aws.amazon.com/iotanalytics/latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions) in the *IoT Analytics User Guide*.
         */
        var versioningConfiguration: aws.sdk.kotlin.services.iotanalytics.model.VersioningConfiguration? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotanalytics.model.UpdateDatasetRequest) : this() {
            this.actions = x.actions
            this.contentDeliveryRules = x.contentDeliveryRules
            this.datasetName = x.datasetName
            this.lateDataRules = x.lateDataRules
            this.retentionPeriod = x.retentionPeriod
            this.triggers = x.triggers
            this.versioningConfiguration = x.versioningConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotanalytics.model.UpdateDatasetRequest = UpdateDatasetRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotanalytics.model.RetentionPeriod] inside the given [block]
         */
        fun retentionPeriod(block: aws.sdk.kotlin.services.iotanalytics.model.RetentionPeriod.Builder.() -> kotlin.Unit) {
            this.retentionPeriod = aws.sdk.kotlin.services.iotanalytics.model.RetentionPeriod.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iotanalytics.model.VersioningConfiguration] inside the given [block]
         */
        fun versioningConfiguration(block: aws.sdk.kotlin.services.iotanalytics.model.VersioningConfiguration.Builder.() -> kotlin.Unit) {
            this.versioningConfiguration = aws.sdk.kotlin.services.iotanalytics.model.VersioningConfiguration.invoke(block)
        }
    }
}
