// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotanalytics.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iotanalytics.model.DatasetContentStatus
import aws.sdk.kotlin.services.iotanalytics.model.DatasetEntry
import aws.sdk.kotlin.services.iotanalytics.model.GetDatasetContentResponse
import aws.sdk.kotlin.services.iotanalytics.model.IoTAnalyticsException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class GetDatasetContentOperationDeserializer: HttpDeserialize<GetDatasetContentResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetDatasetContentResponse {
        if (!response.status.isSuccess()) {
            throwGetDatasetContentError(context, response)
        }
        val builder = GetDatasetContentResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetDatasetContentOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetDatasetContentError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IoTAnalyticsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IoTAnalyticsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetDatasetContentOperationBody(builder: GetDatasetContentResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ENTRIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("entries"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("status"))
    val TIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("timestamp"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ENTRIES_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TIMESTAMP_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ENTRIES_DESCRIPTOR.index -> builder.entries =
                    deserializer.deserializeList(ENTRIES_DESCRIPTOR) {
                        val col0 = mutableListOf<DatasetEntry>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDatasetEntryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                STATUS_DESCRIPTOR.index -> builder.status = deserializeDatasetContentStatusDocument(deserializer)
                TIMESTAMP_DESCRIPTOR.index -> builder.timestamp = deserializeString().let { Instant.fromEpochSeconds(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
