// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotanalytics

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.iotanalytics.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.iotanalytics.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * IoT Analytics allows you to collect large amounts of device data, process messages, and store them. You can then query the data and run sophisticated analytics on it. IoT Analytics enables advanced data exploration through integration with Jupyter Notebooks and data visualization through integration with Amazon QuickSight.
 *
 * Traditional analytics and business intelligence tools are designed to process structured data. IoT data often comes from devices that record noisy processes (such as temperature, motion, or sound). As a result the data from these devices can have significant gaps, corrupted messages, and false readings that must be cleaned up before analysis can occur. Also, IoT data is often only meaningful in the context of other data from external sources.
 *
 * IoT Analytics automates the steps required to analyze data from IoT devices. IoT Analytics filters, transforms, and enriches IoT data before storing it in a time-series data store for analysis. You can set up the service to collect only the data you need from your devices, apply mathematical transforms to process the data, and enrich the data with device-specific metadata such as device type and location before storing it. Then, you can analyze your data by running queries using the built-in SQL query engine, or perform more complex analytics and machine learning inference. IoT Analytics includes pre-built models for common IoT use cases so you can answer questions like which devices are about to fail or which customers are at risk of abandoning their wearable devices.
 */
interface IoTAnalyticsClient : SdkClient {

    override val serviceName: String
        get() = "IoTAnalytics"
    /**
     * IoTAnalyticsClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): IoTAnalyticsClient {
            val config = Config.Builder().apply(block).build()
            return DefaultIoTAnalyticsClient(config)
        }

        operator fun invoke(config: Config): IoTAnalyticsClient = DefaultIoTAnalyticsClient(config)

        /**
         * Construct a [IoTAnalyticsClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): IoTAnalyticsClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultIoTAnalyticsClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Sends messages to a channel.
     */
    suspend fun batchPutMessage(input: BatchPutMessageRequest): BatchPutMessageResponse

    /**
     * Cancels the reprocessing of data through the pipeline.
     */
    suspend fun cancelPipelineReprocessing(input: CancelPipelineReprocessingRequest): CancelPipelineReprocessingResponse

    /**
     * Used to create a channel. A channel collects data from an MQTT topic and archives the raw, unprocessed messages before publishing the data to a pipeline.
     */
    suspend fun createChannel(input: CreateChannelRequest): CreateChannelResponse

    /**
     * Used to create a dataset. A dataset stores data retrieved from a data store by applying a `queryAction` (a SQL query) or a `containerAction` (executing a containerized application). This operation creates the skeleton of a dataset. The dataset can be populated manually by calling `CreateDatasetContent` or automatically according to a trigger you specify.
     */
    suspend fun createDataset(input: CreateDatasetRequest): CreateDatasetResponse

    /**
     * Creates the content of a dataset by applying a `queryAction` (a SQL query) or a `containerAction` (executing a containerized application).
     */
    suspend fun createDatasetContent(input: CreateDatasetContentRequest): CreateDatasetContentResponse

    /**
     * Creates a data store, which is a repository for messages.
     */
    suspend fun createDatastore(input: CreateDatastoreRequest): CreateDatastoreResponse

    /**
     * Creates a pipeline. A pipeline consumes messages from a channel and allows you to process the messages before storing them in a data store. You must specify both a `channel` and a `datastore` activity and, optionally, as many as 23 additional activities in the `pipelineActivities` array.
     */
    suspend fun createPipeline(input: CreatePipelineRequest): CreatePipelineResponse

    /**
     * Deletes the specified channel.
     */
    suspend fun deleteChannel(input: DeleteChannelRequest): DeleteChannelResponse

    /**
     * Deletes the specified dataset.
     *
     * You do not have to delete the content of the dataset before you perform this operation.
     */
    suspend fun deleteDataset(input: DeleteDatasetRequest): DeleteDatasetResponse

    /**
     * Deletes the content of the specified dataset.
     */
    suspend fun deleteDatasetContent(input: DeleteDatasetContentRequest): DeleteDatasetContentResponse

    /**
     * Deletes the specified data store.
     */
    suspend fun deleteDatastore(input: DeleteDatastoreRequest): DeleteDatastoreResponse

    /**
     * Deletes the specified pipeline.
     */
    suspend fun deletePipeline(input: DeletePipelineRequest): DeletePipelineResponse

    /**
     * Retrieves information about a channel.
     */
    suspend fun describeChannel(input: DescribeChannelRequest): DescribeChannelResponse

    /**
     * Retrieves information about a dataset.
     */
    suspend fun describeDataset(input: DescribeDatasetRequest): DescribeDatasetResponse

    /**
     * Retrieves information about a data store.
     */
    suspend fun describeDatastore(input: DescribeDatastoreRequest): DescribeDatastoreResponse

    /**
     * Retrieves the current settings of the IoT Analytics logging options.
     */
    suspend fun describeLoggingOptions(input: DescribeLoggingOptionsRequest = DescribeLoggingOptionsRequest {}): DescribeLoggingOptionsResponse

    /**
     * Retrieves information about a pipeline.
     */
    suspend fun describePipeline(input: DescribePipelineRequest): DescribePipelineResponse

    /**
     * Retrieves the contents of a dataset as presigned URIs.
     */
    suspend fun getDatasetContent(input: GetDatasetContentRequest): GetDatasetContentResponse

    /**
     * Retrieves a list of channels.
     */
    suspend fun listChannels(input: ListChannelsRequest = ListChannelsRequest {}): ListChannelsResponse

    /**
     * Lists information about dataset contents that have been created.
     */
    suspend fun listDatasetContents(input: ListDatasetContentsRequest): ListDatasetContentsResponse

    /**
     * Retrieves information about datasets.
     */
    suspend fun listDatasets(input: ListDatasetsRequest = ListDatasetsRequest {}): ListDatasetsResponse

    /**
     * Retrieves a list of data stores.
     */
    suspend fun listDatastores(input: ListDatastoresRequest = ListDatastoresRequest {}): ListDatastoresResponse

    /**
     * Retrieves a list of pipelines.
     */
    suspend fun listPipelines(input: ListPipelinesRequest = ListPipelinesRequest {}): ListPipelinesResponse

    /**
     * Lists the tags (metadata) that you have assigned to the resource.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Sets or updates the IoT Analytics logging options.
     *
     * If you update the value of any `loggingOptions` field, it takes up to one minute for the change to take effect. Also, if you change the policy attached to the role you specified in the `roleArn` field (for example, to correct an invalid policy), it takes up to five minutes for that change to take effect.
     */
    suspend fun putLoggingOptions(input: PutLoggingOptionsRequest): PutLoggingOptionsResponse

    /**
     * Simulates the results of running a pipeline activity on a message payload.
     */
    suspend fun runPipelineActivity(input: RunPipelineActivityRequest): RunPipelineActivityResponse

    /**
     * Retrieves a sample of messages from the specified channel ingested during the specified timeframe. Up to 10 messages can be retrieved.
     */
    suspend fun sampleChannelData(input: SampleChannelDataRequest): SampleChannelDataResponse

    /**
     * Starts the reprocessing of raw message data through the pipeline.
     */
    suspend fun startPipelineReprocessing(input: StartPipelineReprocessingRequest): StartPipelineReprocessingResponse

    /**
     * Adds to or modifies the tags of the given resource. Tags are metadata that can be used to manage a resource.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes the given tags (metadata) from the resource.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Used to update the settings of a channel.
     */
    suspend fun updateChannel(input: UpdateChannelRequest): UpdateChannelResponse

    /**
     * Updates the settings of a dataset.
     */
    suspend fun updateDataset(input: UpdateDatasetRequest): UpdateDatasetResponse

    /**
     * Used to update the settings of a data store.
     */
    suspend fun updateDatastore(input: UpdateDatastoreRequest): UpdateDatastoreResponse

    /**
     * Updates the settings of a pipeline. You must specify both a `channel` and a `datastore` activity and, optionally, as many as 23 additional activities in the `pipelineActivities` array.
     */
    suspend fun updatePipeline(input: UpdatePipelineRequest): UpdatePipelineResponse
}

/**
 * Sends messages to a channel.
 */
suspend inline fun IoTAnalyticsClient.batchPutMessage(crossinline block: BatchPutMessageRequest.Builder.() -> Unit) = batchPutMessage(BatchPutMessageRequest.Builder().apply(block).build())

/**
 * Cancels the reprocessing of data through the pipeline.
 */
suspend inline fun IoTAnalyticsClient.cancelPipelineReprocessing(crossinline block: CancelPipelineReprocessingRequest.Builder.() -> Unit) = cancelPipelineReprocessing(CancelPipelineReprocessingRequest.Builder().apply(block).build())

/**
 * Used to create a channel. A channel collects data from an MQTT topic and archives the raw, unprocessed messages before publishing the data to a pipeline.
 */
suspend inline fun IoTAnalyticsClient.createChannel(crossinline block: CreateChannelRequest.Builder.() -> Unit) = createChannel(CreateChannelRequest.Builder().apply(block).build())

/**
 * Used to create a dataset. A dataset stores data retrieved from a data store by applying a `queryAction` (a SQL query) or a `containerAction` (executing a containerized application). This operation creates the skeleton of a dataset. The dataset can be populated manually by calling `CreateDatasetContent` or automatically according to a trigger you specify.
 */
suspend inline fun IoTAnalyticsClient.createDataset(crossinline block: CreateDatasetRequest.Builder.() -> Unit) = createDataset(CreateDatasetRequest.Builder().apply(block).build())

/**
 * Creates the content of a dataset by applying a `queryAction` (a SQL query) or a `containerAction` (executing a containerized application).
 */
suspend inline fun IoTAnalyticsClient.createDatasetContent(crossinline block: CreateDatasetContentRequest.Builder.() -> Unit) = createDatasetContent(CreateDatasetContentRequest.Builder().apply(block).build())

/**
 * Creates a data store, which is a repository for messages.
 */
suspend inline fun IoTAnalyticsClient.createDatastore(crossinline block: CreateDatastoreRequest.Builder.() -> Unit) = createDatastore(CreateDatastoreRequest.Builder().apply(block).build())

/**
 * Creates a pipeline. A pipeline consumes messages from a channel and allows you to process the messages before storing them in a data store. You must specify both a `channel` and a `datastore` activity and, optionally, as many as 23 additional activities in the `pipelineActivities` array.
 */
suspend inline fun IoTAnalyticsClient.createPipeline(crossinline block: CreatePipelineRequest.Builder.() -> Unit) = createPipeline(CreatePipelineRequest.Builder().apply(block).build())

/**
 * Deletes the specified channel.
 */
suspend inline fun IoTAnalyticsClient.deleteChannel(crossinline block: DeleteChannelRequest.Builder.() -> Unit) = deleteChannel(DeleteChannelRequest.Builder().apply(block).build())

/**
 * Deletes the specified dataset.
 *
 * You do not have to delete the content of the dataset before you perform this operation.
 */
suspend inline fun IoTAnalyticsClient.deleteDataset(crossinline block: DeleteDatasetRequest.Builder.() -> Unit) = deleteDataset(DeleteDatasetRequest.Builder().apply(block).build())

/**
 * Deletes the content of the specified dataset.
 */
suspend inline fun IoTAnalyticsClient.deleteDatasetContent(crossinline block: DeleteDatasetContentRequest.Builder.() -> Unit) = deleteDatasetContent(DeleteDatasetContentRequest.Builder().apply(block).build())

/**
 * Deletes the specified data store.
 */
suspend inline fun IoTAnalyticsClient.deleteDatastore(crossinline block: DeleteDatastoreRequest.Builder.() -> Unit) = deleteDatastore(DeleteDatastoreRequest.Builder().apply(block).build())

/**
 * Deletes the specified pipeline.
 */
suspend inline fun IoTAnalyticsClient.deletePipeline(crossinline block: DeletePipelineRequest.Builder.() -> Unit) = deletePipeline(DeletePipelineRequest.Builder().apply(block).build())

/**
 * Retrieves information about a channel.
 */
suspend inline fun IoTAnalyticsClient.describeChannel(crossinline block: DescribeChannelRequest.Builder.() -> Unit) = describeChannel(DescribeChannelRequest.Builder().apply(block).build())

/**
 * Retrieves information about a dataset.
 */
suspend inline fun IoTAnalyticsClient.describeDataset(crossinline block: DescribeDatasetRequest.Builder.() -> Unit) = describeDataset(DescribeDatasetRequest.Builder().apply(block).build())

/**
 * Retrieves information about a data store.
 */
suspend inline fun IoTAnalyticsClient.describeDatastore(crossinline block: DescribeDatastoreRequest.Builder.() -> Unit) = describeDatastore(DescribeDatastoreRequest.Builder().apply(block).build())

/**
 * Retrieves the current settings of the IoT Analytics logging options.
 */
suspend inline fun IoTAnalyticsClient.describeLoggingOptions(crossinline block: DescribeLoggingOptionsRequest.Builder.() -> Unit) = describeLoggingOptions(DescribeLoggingOptionsRequest.Builder().apply(block).build())

/**
 * Retrieves information about a pipeline.
 */
suspend inline fun IoTAnalyticsClient.describePipeline(crossinline block: DescribePipelineRequest.Builder.() -> Unit) = describePipeline(DescribePipelineRequest.Builder().apply(block).build())

/**
 * Retrieves the contents of a dataset as presigned URIs.
 */
suspend inline fun IoTAnalyticsClient.getDatasetContent(crossinline block: GetDatasetContentRequest.Builder.() -> Unit) = getDatasetContent(GetDatasetContentRequest.Builder().apply(block).build())

/**
 * Retrieves a list of channels.
 */
suspend inline fun IoTAnalyticsClient.listChannels(crossinline block: ListChannelsRequest.Builder.() -> Unit) = listChannels(ListChannelsRequest.Builder().apply(block).build())

/**
 * Lists information about dataset contents that have been created.
 */
suspend inline fun IoTAnalyticsClient.listDatasetContents(crossinline block: ListDatasetContentsRequest.Builder.() -> Unit) = listDatasetContents(ListDatasetContentsRequest.Builder().apply(block).build())

/**
 * Retrieves information about datasets.
 */
suspend inline fun IoTAnalyticsClient.listDatasets(crossinline block: ListDatasetsRequest.Builder.() -> Unit) = listDatasets(ListDatasetsRequest.Builder().apply(block).build())

/**
 * Retrieves a list of data stores.
 */
suspend inline fun IoTAnalyticsClient.listDatastores(crossinline block: ListDatastoresRequest.Builder.() -> Unit) = listDatastores(ListDatastoresRequest.Builder().apply(block).build())

/**
 * Retrieves a list of pipelines.
 */
suspend inline fun IoTAnalyticsClient.listPipelines(crossinline block: ListPipelinesRequest.Builder.() -> Unit) = listPipelines(ListPipelinesRequest.Builder().apply(block).build())

/**
 * Lists the tags (metadata) that you have assigned to the resource.
 */
suspend inline fun IoTAnalyticsClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Sets or updates the IoT Analytics logging options.
 *
 * If you update the value of any `loggingOptions` field, it takes up to one minute for the change to take effect. Also, if you change the policy attached to the role you specified in the `roleArn` field (for example, to correct an invalid policy), it takes up to five minutes for that change to take effect.
 */
suspend inline fun IoTAnalyticsClient.putLoggingOptions(crossinline block: PutLoggingOptionsRequest.Builder.() -> Unit) = putLoggingOptions(PutLoggingOptionsRequest.Builder().apply(block).build())

/**
 * Simulates the results of running a pipeline activity on a message payload.
 */
suspend inline fun IoTAnalyticsClient.runPipelineActivity(crossinline block: RunPipelineActivityRequest.Builder.() -> Unit) = runPipelineActivity(RunPipelineActivityRequest.Builder().apply(block).build())

/**
 * Retrieves a sample of messages from the specified channel ingested during the specified timeframe. Up to 10 messages can be retrieved.
 */
suspend inline fun IoTAnalyticsClient.sampleChannelData(crossinline block: SampleChannelDataRequest.Builder.() -> Unit) = sampleChannelData(SampleChannelDataRequest.Builder().apply(block).build())

/**
 * Starts the reprocessing of raw message data through the pipeline.
 */
suspend inline fun IoTAnalyticsClient.startPipelineReprocessing(crossinline block: StartPipelineReprocessingRequest.Builder.() -> Unit) = startPipelineReprocessing(StartPipelineReprocessingRequest.Builder().apply(block).build())

/**
 * Adds to or modifies the tags of the given resource. Tags are metadata that can be used to manage a resource.
 */
suspend inline fun IoTAnalyticsClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes the given tags (metadata) from the resource.
 */
suspend inline fun IoTAnalyticsClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Used to update the settings of a channel.
 */
suspend inline fun IoTAnalyticsClient.updateChannel(crossinline block: UpdateChannelRequest.Builder.() -> Unit) = updateChannel(UpdateChannelRequest.Builder().apply(block).build())

/**
 * Updates the settings of a dataset.
 */
suspend inline fun IoTAnalyticsClient.updateDataset(crossinline block: UpdateDatasetRequest.Builder.() -> Unit) = updateDataset(UpdateDatasetRequest.Builder().apply(block).build())

/**
 * Used to update the settings of a data store.
 */
suspend inline fun IoTAnalyticsClient.updateDatastore(crossinline block: UpdateDatastoreRequest.Builder.() -> Unit) = updateDatastore(UpdateDatastoreRequest.Builder().apply(block).build())

/**
 * Updates the settings of a pipeline. You must specify both a `channel` and a `datastore` activity and, optionally, as many as 23 additional activities in the `pipelineActivities` array.
 */
suspend inline fun IoTAnalyticsClient.updatePipeline(crossinline block: UpdatePipelineRequest.Builder.() -> Unit) = updatePipeline(UpdatePipelineRequest.Builder().apply(block).build())
