// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotanalytics.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a data store.
 */
class Datastore private constructor(builder: Builder) {
    /**
     * The ARN of the data store.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * When the data store was created.
     */
    val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * Contains information about the partition dimensions in a data store.
     */
    val datastorePartitions: aws.sdk.kotlin.services.iotanalytics.model.DatastorePartitions? = builder.datastorePartitions
    /**
     * Contains the configuration information of file formats. IoT Analytics data stores support JSON and [Parquet](https://parquet.apache.org/).
     *
     * The default file format is JSON. You can specify only one format.
     *
     * You can't change the file format after you create the data store.
     */
    val fileFormatConfiguration: aws.sdk.kotlin.services.iotanalytics.model.FileFormatConfiguration? = builder.fileFormatConfiguration
    /**
     * The last time when a new message arrived in the data store.
     *
     * IoT Analytics updates this value at most once per minute for Amazon Simple Storage Service one data store. Hence, the `lastMessageArrivalTime` value is an approximation.
     *
     * This feature only applies to messages that arrived in the data store after October 23, 2020.
     */
    val lastMessageArrivalTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastMessageArrivalTime
    /**
     * The last time the data store was updated.
     */
    val lastUpdateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdateTime
    /**
     * The name of the data store.
     */
    val name: kotlin.String? = builder.name
    /**
     * How long, in days, message data is kept for the data store. When `customerManagedS3` storage is selected, this parameter is ignored.
     */
    val retentionPeriod: aws.sdk.kotlin.services.iotanalytics.model.RetentionPeriod? = builder.retentionPeriod
    /**
     * The status of a data store:
     *
     * ## CREATING
     * The data store is being created.
     *
     * ## ACTIVE
     * The data store has been created and can be used.
     *
     * ## DELETING
     * The data store is being deleted.
     */
    val status: aws.sdk.kotlin.services.iotanalytics.model.DatastoreStatus? = builder.status
    /**
     * Where data in a data store is stored.. You can choose `serviceManagedS3` storage, `customerManagedS3` storage, or `iotSiteWiseMultiLayerStorage` storage. The default is `serviceManagedS3`. You can't change the choice of Amazon S3 storage after your data store is created.
     */
    val storage: aws.sdk.kotlin.services.iotanalytics.model.DatastoreStorage? = builder.storage

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotanalytics.model.Datastore = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Datastore(")
        append("arn=$arn,")
        append("creationTime=$creationTime,")
        append("datastorePartitions=$datastorePartitions,")
        append("fileFormatConfiguration=$fileFormatConfiguration,")
        append("lastMessageArrivalTime=$lastMessageArrivalTime,")
        append("lastUpdateTime=$lastUpdateTime,")
        append("name=$name,")
        append("retentionPeriod=$retentionPeriod,")
        append("status=$status,")
        append("storage=$storage)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (datastorePartitions?.hashCode() ?: 0)
        result = 31 * result + (fileFormatConfiguration?.hashCode() ?: 0)
        result = 31 * result + (lastMessageArrivalTime?.hashCode() ?: 0)
        result = 31 * result + (lastUpdateTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (retentionPeriod?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (storage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Datastore

        if (arn != other.arn) return false
        if (creationTime != other.creationTime) return false
        if (datastorePartitions != other.datastorePartitions) return false
        if (fileFormatConfiguration != other.fileFormatConfiguration) return false
        if (lastMessageArrivalTime != other.lastMessageArrivalTime) return false
        if (lastUpdateTime != other.lastUpdateTime) return false
        if (name != other.name) return false
        if (retentionPeriod != other.retentionPeriod) return false
        if (status != other.status) return false
        if (storage != other.storage) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotanalytics.model.Datastore = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ARN of the data store.
         */
        var arn: kotlin.String? = null
        /**
         * When the data store was created.
         */
        var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Contains information about the partition dimensions in a data store.
         */
        var datastorePartitions: aws.sdk.kotlin.services.iotanalytics.model.DatastorePartitions? = null
        /**
         * Contains the configuration information of file formats. IoT Analytics data stores support JSON and [Parquet](https://parquet.apache.org/).
         *
         * The default file format is JSON. You can specify only one format.
         *
         * You can't change the file format after you create the data store.
         */
        var fileFormatConfiguration: aws.sdk.kotlin.services.iotanalytics.model.FileFormatConfiguration? = null
        /**
         * The last time when a new message arrived in the data store.
         *
         * IoT Analytics updates this value at most once per minute for Amazon Simple Storage Service one data store. Hence, the `lastMessageArrivalTime` value is an approximation.
         *
         * This feature only applies to messages that arrived in the data store after October 23, 2020.
         */
        var lastMessageArrivalTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The last time the data store was updated.
         */
        var lastUpdateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the data store.
         */
        var name: kotlin.String? = null
        /**
         * How long, in days, message data is kept for the data store. When `customerManagedS3` storage is selected, this parameter is ignored.
         */
        var retentionPeriod: aws.sdk.kotlin.services.iotanalytics.model.RetentionPeriod? = null
        /**
         * The status of a data store:
         *
         * ## CREATING
         * The data store is being created.
         *
         * ## ACTIVE
         * The data store has been created and can be used.
         *
         * ## DELETING
         * The data store is being deleted.
         */
        var status: aws.sdk.kotlin.services.iotanalytics.model.DatastoreStatus? = null
        /**
         * Where data in a data store is stored.. You can choose `serviceManagedS3` storage, `customerManagedS3` storage, or `iotSiteWiseMultiLayerStorage` storage. The default is `serviceManagedS3`. You can't change the choice of Amazon S3 storage after your data store is created.
         */
        var storage: aws.sdk.kotlin.services.iotanalytics.model.DatastoreStorage? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotanalytics.model.Datastore) : this() {
            this.arn = x.arn
            this.creationTime = x.creationTime
            this.datastorePartitions = x.datastorePartitions
            this.fileFormatConfiguration = x.fileFormatConfiguration
            this.lastMessageArrivalTime = x.lastMessageArrivalTime
            this.lastUpdateTime = x.lastUpdateTime
            this.name = x.name
            this.retentionPeriod = x.retentionPeriod
            this.status = x.status
            this.storage = x.storage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotanalytics.model.Datastore = Datastore(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotanalytics.model.DatastorePartitions] inside the given [block]
         */
        fun datastorePartitions(block: aws.sdk.kotlin.services.iotanalytics.model.DatastorePartitions.Builder.() -> kotlin.Unit) {
            this.datastorePartitions = aws.sdk.kotlin.services.iotanalytics.model.DatastorePartitions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iotanalytics.model.FileFormatConfiguration] inside the given [block]
         */
        fun fileFormatConfiguration(block: aws.sdk.kotlin.services.iotanalytics.model.FileFormatConfiguration.Builder.() -> kotlin.Unit) {
            this.fileFormatConfiguration = aws.sdk.kotlin.services.iotanalytics.model.FileFormatConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iotanalytics.model.RetentionPeriod] inside the given [block]
         */
        fun retentionPeriod(block: aws.sdk.kotlin.services.iotanalytics.model.RetentionPeriod.Builder.() -> kotlin.Unit) {
            this.retentionPeriod = aws.sdk.kotlin.services.iotanalytics.model.RetentionPeriod.invoke(block)
        }
    }
}
