// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotanalytics.model



/**
 * A structure that contains the configuration information of a delta time session window.
 *
 * `DeltaTime`[](https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_DeltaTime.html) specifies a time interval. You can use `DeltaTime` to create dataset contents with data that has arrived in the data store since the last execution. For an example of `DeltaTime`, see [ Creating a SQL dataset with a delta window (CLI)](https://docs.aws.amazon.com/iotanalytics/latest/userguide/automate-create-dataset.html#automate-example6) in the *IoT Analytics User Guide*.
 */
class DeltaTimeSessionWindowConfiguration private constructor(builder: Builder) {
    /**
     * A time interval. You can use `timeoutInMinutes` so that IoT Analytics can batch up late data notifications that have been generated since the last execution. IoT Analytics sends one batch of notifications to Amazon CloudWatch Events at one time.
     *
     * For more information about how to write a timestamp expression, see [Date and Time Functions and Operators](https://prestodb.io/docs/0.172/functions/datetime.html), in the *Presto 0.172 Documentation*.
     */
    val timeoutInMinutes: kotlin.Int? = builder.timeoutInMinutes

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotanalytics.model.DeltaTimeSessionWindowConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeltaTimeSessionWindowConfiguration(")
        append("timeoutInMinutes=$timeoutInMinutes)")
    }

    override fun hashCode(): kotlin.Int {
        var result = timeoutInMinutes ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeltaTimeSessionWindowConfiguration

        if (timeoutInMinutes != other.timeoutInMinutes) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotanalytics.model.DeltaTimeSessionWindowConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * A time interval. You can use `timeoutInMinutes` so that IoT Analytics can batch up late data notifications that have been generated since the last execution. IoT Analytics sends one batch of notifications to Amazon CloudWatch Events at one time.
         *
         * For more information about how to write a timestamp expression, see [Date and Time Functions and Operators](https://prestodb.io/docs/0.172/functions/datetime.html), in the *Presto 0.172 Documentation*.
         */
        var timeoutInMinutes: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotanalytics.model.DeltaTimeSessionWindowConfiguration) : this() {
            this.timeoutInMinutes = x.timeoutInMinutes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotanalytics.model.DeltaTimeSessionWindowConfiguration = DeltaTimeSessionWindowConfiguration(this)
    }
}
