// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotdataplane.model



/**
 * The input for the Publish operation.
 */
class PublishRequest private constructor(builder: Builder) {
    /**
     * The message body. MQTT accepts text, binary, and empty (null) message payloads.
     *
     * Publishing an empty (null) payload with **retain** = `true` deletes the retained message identified by **topic** from Amazon Web Services IoT Core.
     */
    val payload: kotlin.ByteArray? = builder.payload
    /**
     * The Quality of Service (QoS) level.
     */
    val qos: kotlin.Int = builder.qos
    /**
     * A Boolean value that determines whether to set the RETAIN flag when the message is published.
     *
     * Setting the RETAIN flag causes the message to be retained and sent to new subscribers to the topic.
     *
     * Valid values: `true` | `false`
     *
     * Default value: `false`
     */
    val retain: kotlin.Boolean = builder.retain
    /**
     * The name of the MQTT topic.
     */
    val topic: kotlin.String? = requireNotNull(builder.topic) { "A non-null value must be provided for topic" }

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotdataplane.model.PublishRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PublishRequest(")
        append("payload=$payload,")
        append("qos=$qos,")
        append("retain=$retain,")
        append("topic=$topic)")
    }

    override fun hashCode(): kotlin.Int {
        var result = payload?.contentHashCode() ?: 0
        result = 31 * result + (qos)
        result = 31 * result + (retain.hashCode())
        result = 31 * result + (topic?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PublishRequest

        if (payload != null) {
            if (other.payload == null) return false
            if (!payload.contentEquals(other.payload)) return false
        } else if (other.payload != null) return false
        if (qos != other.qos) return false
        if (retain != other.retain) return false
        if (topic != other.topic) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotdataplane.model.PublishRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The message body. MQTT accepts text, binary, and empty (null) message payloads.
         *
         * Publishing an empty (null) payload with **retain** = `true` deletes the retained message identified by **topic** from Amazon Web Services IoT Core.
         */
        var payload: kotlin.ByteArray? = null
        /**
         * The Quality of Service (QoS) level.
         */
        var qos: kotlin.Int = 0
        /**
         * A Boolean value that determines whether to set the RETAIN flag when the message is published.
         *
         * Setting the RETAIN flag causes the message to be retained and sent to new subscribers to the topic.
         *
         * Valid values: `true` | `false`
         *
         * Default value: `false`
         */
        var retain: kotlin.Boolean = false
        /**
         * The name of the MQTT topic.
         */
        var topic: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotdataplane.model.PublishRequest) : this() {
            this.payload = x.payload
            this.qos = x.qos
            this.retain = x.retain
            this.topic = x.topic
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotdataplane.model.PublishRequest = PublishRequest(this)
    }
}
