// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotdataplane.model



/**
 * Information about a single retained message.
 */
class RetainedMessageSummary private constructor(builder: Builder) {
    /**
     * The Epoch date and time, in milliseconds, when the retained message was stored by IoT.
     */
    val lastModifiedTime: kotlin.Long = builder.lastModifiedTime
    /**
     * The size of the retained message's payload in bytes.
     */
    val payloadSize: kotlin.Long = builder.payloadSize
    /**
     * The quality of service (QoS) level used to publish the retained message.
     */
    val qos: kotlin.Int = builder.qos
    /**
     * The topic name to which the retained message was published.
     */
    val topic: kotlin.String? = builder.topic

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotdataplane.model.RetainedMessageSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RetainedMessageSummary(")
        append("lastModifiedTime=$lastModifiedTime,")
        append("payloadSize=$payloadSize,")
        append("qos=$qos,")
        append("topic=$topic)")
    }

    override fun hashCode(): kotlin.Int {
        var result = lastModifiedTime.hashCode()
        result = 31 * result + (payloadSize.hashCode())
        result = 31 * result + (qos)
        result = 31 * result + (topic?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RetainedMessageSummary

        if (lastModifiedTime != other.lastModifiedTime) return false
        if (payloadSize != other.payloadSize) return false
        if (qos != other.qos) return false
        if (topic != other.topic) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotdataplane.model.RetainedMessageSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Epoch date and time, in milliseconds, when the retained message was stored by IoT.
         */
        var lastModifiedTime: kotlin.Long = 0L
        /**
         * The size of the retained message's payload in bytes.
         */
        var payloadSize: kotlin.Long = 0L
        /**
         * The quality of service (QoS) level used to publish the retained message.
         */
        var qos: kotlin.Int = 0
        /**
         * The topic name to which the retained message was published.
         */
        var topic: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotdataplane.model.RetainedMessageSummary) : this() {
            this.lastModifiedTime = x.lastModifiedTime
            this.payloadSize = x.payloadSize
            this.qos = x.qos
            this.topic = x.topic
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotdataplane.model.RetainedMessageSummary = RetainedMessageSummary(this)
    }
}
