// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotdataplane.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iotdataplane.model.GetRetainedMessageResponse
import aws.sdk.kotlin.services.iotdataplane.model.IotDataPlaneException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.util.decodeBase64Bytes


internal class GetRetainedMessageOperationDeserializer: HttpDeserialize<GetRetainedMessageResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetRetainedMessageResponse {
        if (!response.status.isSuccess()) {
            throwGetRetainedMessageError(context, response)
        }
        val builder = GetRetainedMessageResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetRetainedMessageOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetRetainedMessageError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IotDataPlaneException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "MethodNotAllowedException" -> MethodNotAllowedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IotDataPlaneException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetRetainedMessageOperationBody(builder: GetRetainedMessageResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("lastModifiedTime"))
    val PAYLOAD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Blob, JsonSerialName("payload"))
    val QOS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("qos"))
    val TOPIC_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("topic"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(PAYLOAD_DESCRIPTOR)
        field(QOS_DESCRIPTOR)
        field(TOPIC_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeLong()
                PAYLOAD_DESCRIPTOR.index -> builder.payload = deserializeString().decodeBase64Bytes()
                QOS_DESCRIPTOR.index -> builder.qos = deserializeInt()
                TOPIC_DESCRIPTOR.index -> builder.topic = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
