// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotdataplane

import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.client.AwsClientConfig
import aws.sdk.kotlin.runtime.config.AwsClientConfigLoadOptions
import aws.sdk.kotlin.runtime.config.fromEnvironment
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.services.iotdataplane.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.iotdataplane.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucketOptions

/**
 * <fullname>IoT data</fullname>
 * IoT data enables secure, bi-directional communication between Internet-connected things (such as sensors,
 * actuators, embedded devices, or smart appliances) and the Amazon Web Services cloud. It implements a broker for applications and
 * things to publish messages over HTTP (Publish) and retrieve, update, and delete shadows. A shadow is a
 * persistent representation of your things and their state in the Amazon Web Services cloud.
 * Find the endpoint address for actions in IoT data by running this CLI command:
 * aws iot describe-endpoint --endpoint-type iot:Data-ATS
 * The service name used by <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Amazon Web ServicesSignature Version 4
 * to sign requests is: iotdevicegateway.
 */
interface IotDataPlaneClient : SdkClient {

    override val serviceName: String
        get() = "IoT Data Plane"
    /**
     * IotDataPlaneClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(sharedConfig: AwsClientConfig? = null, block: Config.Builder.() -> Unit = {}): IotDataPlaneClient {
            val config = Config.Builder().apply {
                region = sharedConfig?.region
                credentialsProvider = sharedConfig?.credentialsProvider
            }.apply(block).build()
            return DefaultIotDataPlaneClient(config)
        }

        operator fun invoke(config: Config): IotDataPlaneClient = DefaultIotDataPlaneClient(config)

        /**
         * Construct a [IotDataPlaneClient] by resolving the configuration from the current environment.
         * NOTE: If you are using multiple AWS service clients you may wish to share the configuration among them
         * by constructing a [aws.sdk.kotlin.runtime.client.AwsClientConfig] and passing it to each client at construction.
         */
        suspend fun fromEnvironment(block: AwsClientConfigLoadOptions.() -> Unit = {}): IotDataPlaneClient {
            val sharedConfig = AwsClientConfig.fromEnvironment(block)
            return IotDataPlaneClient(sharedConfig)
        }
    }

    class Config private constructor(builder: Builder): AwsClientConfig, HttpClientConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc)
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Deletes the shadow for the specified thing.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteThingShadow action.
     * For more information, see <a href="http://docs.aws.amazon.com/iot/latest/developerguide/API_DeleteThingShadow.html">DeleteThingShadow in the IoT Developer Guide.
     */
    suspend fun deleteThingShadow(input: DeleteThingShadowRequest): DeleteThingShadowResponse

    /**
     * Deletes the shadow for the specified thing.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteThingShadow action.
     * For more information, see <a href="http://docs.aws.amazon.com/iot/latest/developerguide/API_DeleteThingShadow.html">DeleteThingShadow in the IoT Developer Guide.
     */
    suspend fun deleteThingShadow(block: DeleteThingShadowRequest.Builder.() -> Unit) = deleteThingShadow(DeleteThingShadowRequest.Builder().apply(block).build())

    /**
     * Gets the details of a single retained message for the specified topic.
     * This action returns the message payload of the retained message, which can
     * incur messaging costs. To list only the topic names of the retained messages, call
     * <a href="/iot/latest/developerguide/API_iotdata_ListRetainedMessages.html">ListRetainedMessages.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotfleethubfordevicemanagement.html#awsiotfleethubfordevicemanagement-actions-as-permissions">GetRetainedMessage action.
     * For more information about messaging costs, see <a href="http://aws.amazon.com/iot-core/pricing/#Messaging">IoT Core
     * pricing - Messaging.
     */
    suspend fun getRetainedMessage(input: GetRetainedMessageRequest): GetRetainedMessageResponse

    /**
     * Gets the details of a single retained message for the specified topic.
     * This action returns the message payload of the retained message, which can
     * incur messaging costs. To list only the topic names of the retained messages, call
     * <a href="/iot/latest/developerguide/API_iotdata_ListRetainedMessages.html">ListRetainedMessages.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotfleethubfordevicemanagement.html#awsiotfleethubfordevicemanagement-actions-as-permissions">GetRetainedMessage action.
     * For more information about messaging costs, see <a href="http://aws.amazon.com/iot-core/pricing/#Messaging">IoT Core
     * pricing - Messaging.
     */
    suspend fun getRetainedMessage(block: GetRetainedMessageRequest.Builder.() -> Unit) = getRetainedMessage(GetRetainedMessageRequest.Builder().apply(block).build())

    /**
     * Gets the shadow for the specified thing.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetThingShadow action.
     * For more information, see <a href="http://docs.aws.amazon.com/iot/latest/developerguide/API_GetThingShadow.html">GetThingShadow in the
     * IoT Developer Guide.
     */
    suspend fun getThingShadow(input: GetThingShadowRequest): GetThingShadowResponse

    /**
     * Gets the shadow for the specified thing.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetThingShadow action.
     * For more information, see <a href="http://docs.aws.amazon.com/iot/latest/developerguide/API_GetThingShadow.html">GetThingShadow in the
     * IoT Developer Guide.
     */
    suspend fun getThingShadow(block: GetThingShadowRequest.Builder.() -> Unit) = getThingShadow(GetThingShadowRequest.Builder().apply(block).build())

    /**
     * Lists the shadows for the specified thing.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListNamedShadowsForThing action.
     */
    suspend fun listNamedShadowsForThing(input: ListNamedShadowsForThingRequest): ListNamedShadowsForThingResponse

    /**
     * Lists the shadows for the specified thing.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListNamedShadowsForThing action.
     */
    suspend fun listNamedShadowsForThing(block: ListNamedShadowsForThingRequest.Builder.() -> Unit) = listNamedShadowsForThing(ListNamedShadowsForThingRequest.Builder().apply(block).build())

    /**
     * Lists summary information about the retained messages stored for the account.
     * This action returns only the topic names of the retained messages. It doesn't
     * return any message payloads. Although this action doesn't return a message payload,
     * it can still incur messaging costs.
     * To get the message payload of a retained message, call
     * <a href="https://docs.aws.amazon.com/iot/latest/developerguide/API_iotdata_GetRetainedMessage.html">GetRetainedMessage
     * with the topic name of the retained message.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotfleethubfordevicemanagement.html#awsiotfleethubfordevicemanagement-actions-as-permissions">ListRetainedMessages action.
     * For more information about messaging costs, see <a href="http://aws.amazon.com/iot-core/pricing/#Messaging">IoT Core
     * pricing - Messaging.
     */
    suspend fun listRetainedMessages(input: ListRetainedMessagesRequest): ListRetainedMessagesResponse

    /**
     * Lists summary information about the retained messages stored for the account.
     * This action returns only the topic names of the retained messages. It doesn't
     * return any message payloads. Although this action doesn't return a message payload,
     * it can still incur messaging costs.
     * To get the message payload of a retained message, call
     * <a href="https://docs.aws.amazon.com/iot/latest/developerguide/API_iotdata_GetRetainedMessage.html">GetRetainedMessage
     * with the topic name of the retained message.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotfleethubfordevicemanagement.html#awsiotfleethubfordevicemanagement-actions-as-permissions">ListRetainedMessages action.
     * For more information about messaging costs, see <a href="http://aws.amazon.com/iot-core/pricing/#Messaging">IoT Core
     * pricing - Messaging.
     */
    suspend fun listRetainedMessages(block: ListRetainedMessagesRequest.Builder.() -> Unit) = listRetainedMessages(ListRetainedMessagesRequest.Builder().apply(block).build())

    /**
     * Publishes an MQTT message.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">Publish action.
     * For more information about MQTT messages, see
     * <a href="http://docs.aws.amazon.com/iot/latest/developerguide/mqtt.html">MQTT Protocol in the
     * IoT Developer Guide.
     * For more information about messaging costs, see <a href="http://aws.amazon.com/iot-core/pricing/#Messaging">IoT Core
     * pricing - Messaging.
     */
    suspend fun publish(input: PublishRequest): PublishResponse

    /**
     * Publishes an MQTT message.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">Publish action.
     * For more information about MQTT messages, see
     * <a href="http://docs.aws.amazon.com/iot/latest/developerguide/mqtt.html">MQTT Protocol in the
     * IoT Developer Guide.
     * For more information about messaging costs, see <a href="http://aws.amazon.com/iot-core/pricing/#Messaging">IoT Core
     * pricing - Messaging.
     */
    suspend fun publish(block: PublishRequest.Builder.() -> Unit) = publish(PublishRequest.Builder().apply(block).build())

    /**
     * Updates the shadow for the specified thing.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateThingShadow action.
     * For more information, see <a href="http://docs.aws.amazon.com/iot/latest/developerguide/API_UpdateThingShadow.html">UpdateThingShadow in the
     * IoT Developer Guide.
     */
    suspend fun updateThingShadow(input: UpdateThingShadowRequest): UpdateThingShadowResponse

    /**
     * Updates the shadow for the specified thing.
     * Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateThingShadow action.
     * For more information, see <a href="http://docs.aws.amazon.com/iot/latest/developerguide/API_UpdateThingShadow.html">UpdateThingShadow in the
     * IoT Developer Guide.
     */
    suspend fun updateThingShadow(block: UpdateThingShadowRequest.Builder.() -> Unit) = updateThingShadow(UpdateThingShadowRequest.Builder().apply(block).build())
}
