// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotdataplane.model



/**
 * The output from the GetRetainedMessage operation.
 */
class GetRetainedMessageResponse private constructor(builder: Builder) {
    /**
     * The Epoch date and time, in milliseconds, when the retained message was stored by IoT.
     */
    val lastModifiedTime: kotlin.Long = builder.lastModifiedTime
    /**
     * The Base64-encoded message payload of the retained message body.
     */
    val payload: kotlin.ByteArray? = builder.payload
    /**
     * The quality of service (QoS) level used to publish the retained message.
     */
    val qos: kotlin.Int = builder.qos
    /**
     * The topic name to which the retained message was published.
     */
    val topic: kotlin.String? = builder.topic

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotdataplane.model.GetRetainedMessageResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetRetainedMessageResponse(")
        append("lastModifiedTime=$lastModifiedTime,")
        append("payload=$payload,")
        append("qos=$qos,")
        append("topic=$topic)")
    }

    override fun hashCode(): kotlin.Int {
        var result = lastModifiedTime.hashCode()
        result = 31 * result + (payload?.contentHashCode() ?: 0)
        result = 31 * result + (qos)
        result = 31 * result + (topic?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as GetRetainedMessageResponse

        if (lastModifiedTime != other.lastModifiedTime) return false
        if (payload != null) {
            if (other.payload == null) return false
            if (!payload.contentEquals(other.payload)) return false
        } else if (other.payload != null) return false
        if (qos != other.qos) return false
        if (topic != other.topic) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotdataplane.model.GetRetainedMessageResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Epoch date and time, in milliseconds, when the retained message was stored by IoT.
         */
        var lastModifiedTime: kotlin.Long = 0L
        /**
         * The Base64-encoded message payload of the retained message body.
         */
        var payload: kotlin.ByteArray? = null
        /**
         * The quality of service (QoS) level used to publish the retained message.
         */
        var qos: kotlin.Int = 0
        /**
         * The topic name to which the retained message was published.
         */
        var topic: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotdataplane.model.GetRetainedMessageResponse) : this() {
            this.lastModifiedTime = x.lastModifiedTime
            this.payload = x.payload
            this.qos = x.qos
            this.topic = x.topic
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotdataplane.model.GetRetainedMessageResponse = GetRetainedMessageResponse(this)
    }
}
