// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotdataplane.transform

import aws.sdk.kotlin.services.iotdataplane.model.PublishRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.parameters
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel


internal class PublishOperationSerializer: HttpSerialize<PublishRequest> {
    override suspend fun serialize(context: ExecutionContext, input: PublishRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "topics",
                "${input.topic}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
            parameters {
                if (input.qos != 0) append("qos", "${input.qos}")
                if (input.retain != false) append("retain", "${input.retain}")
            }
        }

        if (input.payload != null) {
            builder.body = ByteArrayContent(input.payload)
        }
        builder.headers.setMissing("Content-Type", "application/octet-stream")
        return builder
    }
}
