// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotdataplane.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iotdataplane.model.IotDataPlaneException
import aws.sdk.kotlin.services.iotdataplane.model.UpdateThingShadowResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class UpdateThingShadowOperationDeserializer: HttpDeserialize<UpdateThingShadowResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateThingShadowResponse {
        if (!response.status.isSuccess()) {
            throwUpdateThingShadowError(context, response)
        }
        val builder = UpdateThingShadowResponse.Builder()

        builder.payload = response.body.readAll()

        return builder.build()
    }
}

private suspend fun throwUpdateThingShadowError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restJson1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "ConflictException" -> ConflictExceptionDeserializer()
        "InternalFailureException" -> InternalFailureExceptionDeserializer()
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer()
        "MethodNotAllowedException" -> MethodNotAllowedExceptionDeserializer()
        "RequestEntityTooLargeException" -> RequestEntityTooLargeExceptionDeserializer()
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer()
        "ThrottlingException" -> ThrottlingExceptionDeserializer()
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer()
        "UnsupportedDocumentEncodingException" -> UnsupportedDocumentEncodingExceptionDeserializer()
        else -> throw IotDataPlaneException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
