// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotdeviceadvisor.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iotdeviceadvisor.model.GetSuiteRunResponse
import aws.sdk.kotlin.services.iotdeviceadvisor.model.IotDeviceAdvisorException
import aws.sdk.kotlin.services.iotdeviceadvisor.model.SuiteRunConfiguration
import aws.sdk.kotlin.services.iotdeviceadvisor.model.SuiteRunStatus
import aws.sdk.kotlin.services.iotdeviceadvisor.model.TestResult
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class GetSuiteRunOperationDeserializer: HttpDeserialize<GetSuiteRunResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetSuiteRunResponse {
        if (!response.status.isSuccess()) {
            throwGetSuiteRunError(context, response)
        }
        val builder = GetSuiteRunResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetSuiteRunOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetSuiteRunError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IotDeviceAdvisorException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IotDeviceAdvisorException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetSuiteRunOperationBody(builder: GetSuiteRunResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("endTime"))
    val ERRORREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("errorReason"))
    val STARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("startTime"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("status"))
    val SUITEDEFINITIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("suiteDefinitionId"))
    val SUITEDEFINITIONVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("suiteDefinitionVersion"))
    val SUITERUNARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("suiteRunArn"))
    val SUITERUNCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("suiteRunConfiguration"))
    val SUITERUNID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("suiteRunId"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val TESTRESULT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("testResult"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ENDTIME_DESCRIPTOR)
        field(ERRORREASON_DESCRIPTOR)
        field(STARTTIME_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(SUITEDEFINITIONID_DESCRIPTOR)
        field(SUITEDEFINITIONVERSION_DESCRIPTOR)
        field(SUITERUNARN_DESCRIPTOR)
        field(SUITERUNCONFIGURATION_DESCRIPTOR)
        field(SUITERUNID_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TESTRESULT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ENDTIME_DESCRIPTOR.index -> builder.endTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                ERRORREASON_DESCRIPTOR.index -> builder.errorReason = deserializeString()
                STARTTIME_DESCRIPTOR.index -> builder.startTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { SuiteRunStatus.fromValue(it) }
                SUITEDEFINITIONID_DESCRIPTOR.index -> builder.suiteDefinitionId = deserializeString()
                SUITEDEFINITIONVERSION_DESCRIPTOR.index -> builder.suiteDefinitionVersion = deserializeString()
                SUITERUNARN_DESCRIPTOR.index -> builder.suiteRunArn = deserializeString()
                SUITERUNCONFIGURATION_DESCRIPTOR.index -> builder.suiteRunConfiguration = deserializeSuiteRunConfigurationDocument(deserializer)
                SUITERUNID_DESCRIPTOR.index -> builder.suiteRunId = deserializeString()
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                TESTRESULT_DESCRIPTOR.index -> builder.testResult = deserializeTestResultDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
