// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotdeviceadvisor.transform

import aws.sdk.kotlin.services.iotdeviceadvisor.model.StartSuiteRunRequest
import aws.sdk.kotlin.services.iotdeviceadvisor.model.SuiteRunConfiguration
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class StartSuiteRunOperationSerializer: HttpSerialize<StartSuiteRunRequest> {
    override suspend fun serialize(context: ExecutionContext, input: StartSuiteRunRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "suiteDefinitions",
                "${input.suiteDefinitionId}".encodeLabel(),
                "suiteRuns",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeStartSuiteRunOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeStartSuiteRunOperationBody(context: ExecutionContext, input: StartSuiteRunRequest): ByteArray {
    val serializer = JsonSerializer()
    val SUITEDEFINITIONVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("suiteDefinitionVersion"))
    val SUITERUNCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("suiteRunConfiguration"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(SUITEDEFINITIONVERSION_DESCRIPTOR)
        field(SUITERUNCONFIGURATION_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.suiteDefinitionVersion?.let { field(SUITEDEFINITIONVERSION_DESCRIPTOR, it) }
        input.suiteRunConfiguration?.let { field(SUITERUNCONFIGURATION_DESCRIPTOR, it, ::serializeSuiteRunConfigurationDocument) }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) -> entry(key, value) }
            }
        }
    }
    return serializer.toByteArray()
}
