// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotdeviceadvisor

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.iotdeviceadvisor.model.*
import aws.sdk.kotlin.services.iotdeviceadvisor.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.middleware.Retry
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "IotDeviceAdvisor"
const val ServiceApiVersion: String = "2020-09-18"
const val SdkVersion: String = "0.15.2-beta"

internal class DefaultIotDeviceAdvisorClient(override val config: IotDeviceAdvisorClient.Config) : IotDeviceAdvisorClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Creates a Device Advisor test suite.
     *
     * Requires permission to access the [CreateSuiteDefinition](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    override suspend fun createSuiteDefinition(input: CreateSuiteDefinitionRequest): CreateSuiteDefinitionResponse {
        val op = SdkHttpOperation.build<CreateSuiteDefinitionRequest, CreateSuiteDefinitionResponse> {
            serializer = CreateSuiteDefinitionOperationSerializer()
            deserializer = CreateSuiteDefinitionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateSuiteDefinition"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotdeviceadvisor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a Device Advisor test suite.
     *
     * Requires permission to access the [DeleteSuiteDefinition](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    override suspend fun deleteSuiteDefinition(input: DeleteSuiteDefinitionRequest): DeleteSuiteDefinitionResponse {
        val op = SdkHttpOperation.build<DeleteSuiteDefinitionRequest, DeleteSuiteDefinitionResponse> {
            serializer = DeleteSuiteDefinitionOperationSerializer()
            deserializer = DeleteSuiteDefinitionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteSuiteDefinition"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotdeviceadvisor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about an Device Advisor endpoint.
     */
    override suspend fun getEndpoint(input: GetEndpointRequest): GetEndpointResponse {
        val op = SdkHttpOperation.build<GetEndpointRequest, GetEndpointResponse> {
            serializer = GetEndpointOperationSerializer()
            deserializer = GetEndpointOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetEndpoint"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotdeviceadvisor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a Device Advisor test suite.
     *
     * Requires permission to access the [GetSuiteDefinition](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    override suspend fun getSuiteDefinition(input: GetSuiteDefinitionRequest): GetSuiteDefinitionResponse {
        val op = SdkHttpOperation.build<GetSuiteDefinitionRequest, GetSuiteDefinitionResponse> {
            serializer = GetSuiteDefinitionOperationSerializer()
            deserializer = GetSuiteDefinitionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSuiteDefinition"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotdeviceadvisor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a Device Advisor test suite run.
     *
     * Requires permission to access the [GetSuiteRun](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    override suspend fun getSuiteRun(input: GetSuiteRunRequest): GetSuiteRunResponse {
        val op = SdkHttpOperation.build<GetSuiteRunRequest, GetSuiteRunResponse> {
            serializer = GetSuiteRunOperationSerializer()
            deserializer = GetSuiteRunOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSuiteRun"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotdeviceadvisor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a report download link for a successful Device Advisor qualifying test suite run.
     *
     * Requires permission to access the [GetSuiteRunReport](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    override suspend fun getSuiteRunReport(input: GetSuiteRunReportRequest): GetSuiteRunReportResponse {
        val op = SdkHttpOperation.build<GetSuiteRunReportRequest, GetSuiteRunReportResponse> {
            serializer = GetSuiteRunReportOperationSerializer()
            deserializer = GetSuiteRunReportOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSuiteRunReport"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotdeviceadvisor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the Device Advisor test suites you have created.
     *
     * Requires permission to access the [ListSuiteDefinitions](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    override suspend fun listSuiteDefinitions(input: ListSuiteDefinitionsRequest): ListSuiteDefinitionsResponse {
        val op = SdkHttpOperation.build<ListSuiteDefinitionsRequest, ListSuiteDefinitionsResponse> {
            serializer = ListSuiteDefinitionsOperationSerializer()
            deserializer = ListSuiteDefinitionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListSuiteDefinitions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotdeviceadvisor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists runs of the specified Device Advisor test suite. You can list all runs of the test suite, or the runs of a specific version of the test suite.
     *
     * Requires permission to access the [ListSuiteRuns](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    override suspend fun listSuiteRuns(input: ListSuiteRunsRequest): ListSuiteRunsResponse {
        val op = SdkHttpOperation.build<ListSuiteRunsRequest, ListSuiteRunsResponse> {
            serializer = ListSuiteRunsOperationSerializer()
            deserializer = ListSuiteRunsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListSuiteRuns"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotdeviceadvisor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the tags attached to an IoT Device Advisor resource.
     *
     * Requires permission to access the [ListTagsForResource](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotdeviceadvisor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts a Device Advisor test suite run.
     *
     * Requires permission to access the [StartSuiteRun](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    override suspend fun startSuiteRun(input: StartSuiteRunRequest): StartSuiteRunResponse {
        val op = SdkHttpOperation.build<StartSuiteRunRequest, StartSuiteRunResponse> {
            serializer = StartSuiteRunOperationSerializer()
            deserializer = StartSuiteRunOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartSuiteRun"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotdeviceadvisor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Stops a Device Advisor test suite run that is currently running.
     *
     * Requires permission to access the [StopSuiteRun](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    override suspend fun stopSuiteRun(input: StopSuiteRunRequest): StopSuiteRunResponse {
        val op = SdkHttpOperation.build<StopSuiteRunRequest, StopSuiteRunResponse> {
            serializer = StopSuiteRunOperationSerializer()
            deserializer = StopSuiteRunOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StopSuiteRun"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotdeviceadvisor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds to and modifies existing tags of an IoT Device Advisor resource.
     *
     * Requires permission to access the [TagResource](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotdeviceadvisor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes tags from an IoT Device Advisor resource.
     *
     * Requires permission to access the [UntagResource](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotdeviceadvisor"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a Device Advisor test suite.
     *
     * Requires permission to access the [UpdateSuiteDefinition](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    override suspend fun updateSuiteDefinition(input: UpdateSuiteDefinitionRequest): UpdateSuiteDefinitionResponse {
        val op = SdkHttpOperation.build<UpdateSuiteDefinitionRequest, UpdateSuiteDefinitionResponse> {
            serializer = UpdateSuiteDefinitionOperationSerializer()
            deserializer = UpdateSuiteDefinitionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateSuiteDefinition"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotdeviceadvisor"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "iotdeviceadvisor")
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
