// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotdeviceadvisor

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.iotdeviceadvisor.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.iotdeviceadvisor.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.crt.CrtAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * Amazon Web Services IoT Core Device Advisor is a cloud-based, fully managed test capability for validating IoT devices during device software development. Device Advisor provides pre-built tests that you can use to validate IoT devices for reliable and secure connectivity with Amazon Web Services IoT Core before deploying devices to production. By using Device Advisor, you can confirm that your devices can connect to Amazon Web Services IoT Core, follow security best practices and, if applicable, receive software updates from IoT Device Management. You can also download signed qualification reports to submit to the Amazon Web Services Partner Network to get your device qualified for the Amazon Web Services Partner Device Catalog without the need to send your device in and wait for it to be tested.
 */
interface IotDeviceAdvisorClient : SdkClient {

    override val serviceName: String
        get() = "IotDeviceAdvisor"
    /**
     * IotDeviceAdvisorClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): IotDeviceAdvisorClient {
            val config = Config.Builder().apply(block).build()
            return DefaultIotDeviceAdvisorClient(config)
        }

        operator fun invoke(config: Config): IotDeviceAdvisorClient = DefaultIotDeviceAdvisorClient(config)

        /**
         * Construct a [IotDeviceAdvisorClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): IotDeviceAdvisorClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultIotDeviceAdvisorClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: CrtAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a Device Advisor test suite.
     *
     * Requires permission to access the [CreateSuiteDefinition](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    suspend fun createSuiteDefinition(input: CreateSuiteDefinitionRequest): CreateSuiteDefinitionResponse

    /**
     * Creates a Device Advisor test suite.
     *
     * Requires permission to access the [CreateSuiteDefinition](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    suspend fun createSuiteDefinition(block: CreateSuiteDefinitionRequest.Builder.() -> Unit) = createSuiteDefinition(CreateSuiteDefinitionRequest.Builder().apply(block).build())

    /**
     * Deletes a Device Advisor test suite.
     *
     * Requires permission to access the [DeleteSuiteDefinition](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    suspend fun deleteSuiteDefinition(input: DeleteSuiteDefinitionRequest): DeleteSuiteDefinitionResponse

    /**
     * Deletes a Device Advisor test suite.
     *
     * Requires permission to access the [DeleteSuiteDefinition](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    suspend fun deleteSuiteDefinition(block: DeleteSuiteDefinitionRequest.Builder.() -> Unit) = deleteSuiteDefinition(DeleteSuiteDefinitionRequest.Builder().apply(block).build())

    /**
     * Gets information about an Device Advisor endpoint.
     */
    suspend fun getEndpoint(input: GetEndpointRequest): GetEndpointResponse

    /**
     * Gets information about an Device Advisor endpoint.
     */
    suspend fun getEndpoint(block: GetEndpointRequest.Builder.() -> Unit) = getEndpoint(GetEndpointRequest.Builder().apply(block).build())

    /**
     * Gets information about a Device Advisor test suite.
     *
     * Requires permission to access the [GetSuiteDefinition](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    suspend fun getSuiteDefinition(input: GetSuiteDefinitionRequest): GetSuiteDefinitionResponse

    /**
     * Gets information about a Device Advisor test suite.
     *
     * Requires permission to access the [GetSuiteDefinition](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    suspend fun getSuiteDefinition(block: GetSuiteDefinitionRequest.Builder.() -> Unit) = getSuiteDefinition(GetSuiteDefinitionRequest.Builder().apply(block).build())

    /**
     * Gets information about a Device Advisor test suite run.
     *
     * Requires permission to access the [GetSuiteRun](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    suspend fun getSuiteRun(input: GetSuiteRunRequest): GetSuiteRunResponse

    /**
     * Gets information about a Device Advisor test suite run.
     *
     * Requires permission to access the [GetSuiteRun](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    suspend fun getSuiteRun(block: GetSuiteRunRequest.Builder.() -> Unit) = getSuiteRun(GetSuiteRunRequest.Builder().apply(block).build())

    /**
     * Gets a report download link for a successful Device Advisor qualifying test suite run.
     *
     * Requires permission to access the [GetSuiteRunReport](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    suspend fun getSuiteRunReport(input: GetSuiteRunReportRequest): GetSuiteRunReportResponse

    /**
     * Gets a report download link for a successful Device Advisor qualifying test suite run.
     *
     * Requires permission to access the [GetSuiteRunReport](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    suspend fun getSuiteRunReport(block: GetSuiteRunReportRequest.Builder.() -> Unit) = getSuiteRunReport(GetSuiteRunReportRequest.Builder().apply(block).build())

    /**
     * Lists the Device Advisor test suites you have created.
     *
     * Requires permission to access the [ListSuiteDefinitions](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    suspend fun listSuiteDefinitions(input: ListSuiteDefinitionsRequest): ListSuiteDefinitionsResponse

    /**
     * Lists the Device Advisor test suites you have created.
     *
     * Requires permission to access the [ListSuiteDefinitions](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    suspend fun listSuiteDefinitions(block: ListSuiteDefinitionsRequest.Builder.() -> Unit) = listSuiteDefinitions(ListSuiteDefinitionsRequest.Builder().apply(block).build())

    /**
     * Lists runs of the specified Device Advisor test suite. You can list all runs of the test suite, or the runs of a specific version of the test suite.
     *
     * Requires permission to access the [ListSuiteRuns](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    suspend fun listSuiteRuns(input: ListSuiteRunsRequest): ListSuiteRunsResponse

    /**
     * Lists runs of the specified Device Advisor test suite. You can list all runs of the test suite, or the runs of a specific version of the test suite.
     *
     * Requires permission to access the [ListSuiteRuns](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    suspend fun listSuiteRuns(block: ListSuiteRunsRequest.Builder.() -> Unit) = listSuiteRuns(ListSuiteRunsRequest.Builder().apply(block).build())

    /**
     * Lists the tags attached to an IoT Device Advisor resource.
     *
     * Requires permission to access the [ListTagsForResource](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists the tags attached to an IoT Device Advisor resource.
     *
     * Requires permission to access the [ListTagsForResource](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

    /**
     * Starts a Device Advisor test suite run.
     *
     * Requires permission to access the [StartSuiteRun](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    suspend fun startSuiteRun(input: StartSuiteRunRequest): StartSuiteRunResponse

    /**
     * Starts a Device Advisor test suite run.
     *
     * Requires permission to access the [StartSuiteRun](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    suspend fun startSuiteRun(block: StartSuiteRunRequest.Builder.() -> Unit) = startSuiteRun(StartSuiteRunRequest.Builder().apply(block).build())

    /**
     * Stops a Device Advisor test suite run that is currently running.
     *
     * Requires permission to access the [StopSuiteRun](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    suspend fun stopSuiteRun(input: StopSuiteRunRequest): StopSuiteRunResponse

    /**
     * Stops a Device Advisor test suite run that is currently running.
     *
     * Requires permission to access the [StopSuiteRun](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    suspend fun stopSuiteRun(block: StopSuiteRunRequest.Builder.() -> Unit) = stopSuiteRun(StopSuiteRunRequest.Builder().apply(block).build())

    /**
     * Adds to and modifies existing tags of an IoT Device Advisor resource.
     *
     * Requires permission to access the [TagResource](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Adds to and modifies existing tags of an IoT Device Advisor resource.
     *
     * Requires permission to access the [TagResource](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    suspend fun tagResource(block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

    /**
     * Removes tags from an IoT Device Advisor resource.
     *
     * Requires permission to access the [UntagResource](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes tags from an IoT Device Advisor resource.
     *
     * Requires permission to access the [UntagResource](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    suspend fun untagResource(block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

    /**
     * Updates a Device Advisor test suite.
     *
     * Requires permission to access the [UpdateSuiteDefinition](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    suspend fun updateSuiteDefinition(input: UpdateSuiteDefinitionRequest): UpdateSuiteDefinitionResponse

    /**
     * Updates a Device Advisor test suite.
     *
     * Requires permission to access the [UpdateSuiteDefinition](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    suspend fun updateSuiteDefinition(block: UpdateSuiteDefinitionRequest.Builder.() -> Unit) = updateSuiteDefinition(UpdateSuiteDefinitionRequest.Builder().apply(block).build())
}
