// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotdeviceadvisor.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iotdeviceadvisor.model.CreateSuiteDefinitionResponse
import aws.sdk.kotlin.services.iotdeviceadvisor.model.IotDeviceAdvisorException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class CreateSuiteDefinitionOperationDeserializer: HttpDeserialize<CreateSuiteDefinitionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateSuiteDefinitionResponse {
        if (!response.status.isSuccess()) {
            throwCreateSuiteDefinitionError(context, response)
        }
        val builder = CreateSuiteDefinitionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateSuiteDefinitionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateSuiteDefinitionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IotDeviceAdvisorException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IotDeviceAdvisorException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateSuiteDefinitionOperationBody(builder: CreateSuiteDefinitionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdAt"))
    val SUITEDEFINITIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("suiteDefinitionArn"))
    val SUITEDEFINITIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("suiteDefinitionId"))
    val SUITEDEFINITIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("suiteDefinitionName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATEDAT_DESCRIPTOR)
        field(SUITEDEFINITIONARN_DESCRIPTOR)
        field(SUITEDEFINITIONID_DESCRIPTOR)
        field(SUITEDEFINITIONNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                SUITEDEFINITIONARN_DESCRIPTOR.index -> builder.suiteDefinitionArn = deserializeString()
                SUITEDEFINITIONID_DESCRIPTOR.index -> builder.suiteDefinitionId = deserializeString()
                SUITEDEFINITIONNAME_DESCRIPTOR.index -> builder.suiteDefinitionName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
