// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotdeviceadvisor.paginators

import aws.sdk.kotlin.services.iotdeviceadvisor.IotDeviceAdvisorClient
import aws.sdk.kotlin.services.iotdeviceadvisor.model.ListSuiteDefinitionsRequest
import aws.sdk.kotlin.services.iotdeviceadvisor.model.ListSuiteDefinitionsResponse
import aws.sdk.kotlin.services.iotdeviceadvisor.model.ListSuiteRunsRequest
import aws.sdk.kotlin.services.iotdeviceadvisor.model.ListSuiteRunsResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [ListSuiteDefinitionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSuiteDefinitionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSuiteDefinitionsResponse]
 */
public fun IotDeviceAdvisorClient.listSuiteDefinitionsPaginated(initialRequest: ListSuiteDefinitionsRequest): Flow<ListSuiteDefinitionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSuiteDefinitionsPaginated.listSuiteDefinitions(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListSuiteDefinitionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSuiteDefinitionsResponse]
 */
public fun IotDeviceAdvisorClient.listSuiteDefinitionsPaginated(block: ListSuiteDefinitionsRequest.Builder.() -> Unit): Flow<ListSuiteDefinitionsResponse> =
    listSuiteDefinitionsPaginated(ListSuiteDefinitionsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListSuiteRunsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSuiteRunsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSuiteRunsResponse]
 */
public fun IotDeviceAdvisorClient.listSuiteRunsPaginated(initialRequest: ListSuiteRunsRequest): Flow<ListSuiteRunsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSuiteRunsPaginated.listSuiteRuns(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListSuiteRunsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSuiteRunsResponse]
 */
public fun IotDeviceAdvisorClient.listSuiteRunsPaginated(block: ListSuiteRunsRequest.Builder.() -> Unit): Flow<ListSuiteRunsResponse> =
    listSuiteRunsPaginated(ListSuiteRunsRequest.Builder().apply(block).build())
