// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ioteventsdata

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.ioteventsdata.model.*
import aws.sdk.kotlin.services.ioteventsdata.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "IoT Events Data"
const val ServiceApiVersion: String = "2018-10-23"
const val SdkVersion: String = "0.16.3-beta"

internal class DefaultIotEventsDataClient(override val config: IotEventsDataClient.Config) : IotEventsDataClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Acknowledges one or more alarms. The alarms change to the `ACKNOWLEDGED` state after you acknowledge them.
     */
    override suspend fun batchAcknowledgeAlarm(input: BatchAcknowledgeAlarmRequest): BatchAcknowledgeAlarmResponse {
        val op = SdkHttpOperation.build<BatchAcknowledgeAlarmRequest, BatchAcknowledgeAlarmResponse> {
            serializer = BatchAcknowledgeAlarmOperationSerializer()
            deserializer = BatchAcknowledgeAlarmOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "BatchAcknowledgeAlarm"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ioteventsdata"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes one or more detectors that were created. When a detector is deleted, its state will be cleared and the detector will be removed from the list of detectors. The deleted detector will no longer appear if referenced in the [ListDetectors](https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_ListDetectors.html) API call.
     */
    override suspend fun batchDeleteDetector(input: BatchDeleteDetectorRequest): BatchDeleteDetectorResponse {
        val op = SdkHttpOperation.build<BatchDeleteDetectorRequest, BatchDeleteDetectorResponse> {
            serializer = BatchDeleteDetectorOperationSerializer()
            deserializer = BatchDeleteDetectorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchDeleteDetector"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ioteventsdata"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disables one or more alarms. The alarms change to the `DISABLED` state after you disable them.
     */
    override suspend fun batchDisableAlarm(input: BatchDisableAlarmRequest): BatchDisableAlarmResponse {
        val op = SdkHttpOperation.build<BatchDisableAlarmRequest, BatchDisableAlarmResponse> {
            serializer = BatchDisableAlarmOperationSerializer()
            deserializer = BatchDisableAlarmOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "BatchDisableAlarm"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ioteventsdata"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Enables one or more alarms. The alarms change to the `NORMAL` state after you enable them.
     */
    override suspend fun batchEnableAlarm(input: BatchEnableAlarmRequest): BatchEnableAlarmResponse {
        val op = SdkHttpOperation.build<BatchEnableAlarmRequest, BatchEnableAlarmResponse> {
            serializer = BatchEnableAlarmOperationSerializer()
            deserializer = BatchEnableAlarmOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "BatchEnableAlarm"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ioteventsdata"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Sends a set of messages to the IoT Events system. Each message payload is transformed into the input you specify (`"inputName"`) and ingested into any detectors that monitor that input. If multiple messages are sent, the order in which the messages are processed isn't guaranteed. To guarantee ordering, you must send messages one at a time and wait for a successful response.
     */
    override suspend fun batchPutMessage(input: BatchPutMessageRequest): BatchPutMessageResponse {
        val op = SdkHttpOperation.build<BatchPutMessageRequest, BatchPutMessageResponse> {
            serializer = BatchPutMessageOperationSerializer()
            deserializer = BatchPutMessageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchPutMessage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ioteventsdata"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Resets one or more alarms. The alarms return to the `NORMAL` state after you reset them.
     */
    override suspend fun batchResetAlarm(input: BatchResetAlarmRequest): BatchResetAlarmResponse {
        val op = SdkHttpOperation.build<BatchResetAlarmRequest, BatchResetAlarmResponse> {
            serializer = BatchResetAlarmOperationSerializer()
            deserializer = BatchResetAlarmOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "BatchResetAlarm"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ioteventsdata"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Changes one or more alarms to the snooze mode. The alarms change to the `SNOOZE_DISABLED` state after you set them to the snooze mode.
     */
    override suspend fun batchSnoozeAlarm(input: BatchSnoozeAlarmRequest): BatchSnoozeAlarmResponse {
        val op = SdkHttpOperation.build<BatchSnoozeAlarmRequest, BatchSnoozeAlarmResponse> {
            serializer = BatchSnoozeAlarmOperationSerializer()
            deserializer = BatchSnoozeAlarmOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "BatchSnoozeAlarm"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ioteventsdata"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the state, variable values, and timer settings of one or more detectors (instances) of a specified detector model.
     */
    override suspend fun batchUpdateDetector(input: BatchUpdateDetectorRequest): BatchUpdateDetectorResponse {
        val op = SdkHttpOperation.build<BatchUpdateDetectorRequest, BatchUpdateDetectorResponse> {
            serializer = BatchUpdateDetectorOperationSerializer()
            deserializer = BatchUpdateDetectorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchUpdateDetector"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ioteventsdata"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about an alarm.
     */
    override suspend fun describeAlarm(input: DescribeAlarmRequest): DescribeAlarmResponse {
        val op = SdkHttpOperation.build<DescribeAlarmRequest, DescribeAlarmResponse> {
            serializer = DescribeAlarmOperationSerializer()
            deserializer = DescribeAlarmOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAlarm"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ioteventsdata"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about the specified detector (instance).
     */
    override suspend fun describeDetector(input: DescribeDetectorRequest): DescribeDetectorResponse {
        val op = SdkHttpOperation.build<DescribeDetectorRequest, DescribeDetectorResponse> {
            serializer = DescribeDetectorOperationSerializer()
            deserializer = DescribeDetectorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDetector"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ioteventsdata"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists one or more alarms. The operation returns only the metadata associated with each alarm.
     */
    override suspend fun listAlarms(input: ListAlarmsRequest): ListAlarmsResponse {
        val op = SdkHttpOperation.build<ListAlarmsRequest, ListAlarmsResponse> {
            serializer = ListAlarmsOperationSerializer()
            deserializer = ListAlarmsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAlarms"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ioteventsdata"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists detectors (the instances of a detector model).
     */
    override suspend fun listDetectors(input: ListDetectorsRequest): ListDetectorsResponse {
        val op = SdkHttpOperation.build<ListDetectorsRequest, ListDetectorsResponse> {
            serializer = ListDetectorsOperationSerializer()
            deserializer = ListDetectorsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDetectors"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ioteventsdata"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "ioteventsdata")
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
