// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ioteventsdata

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.ioteventsdata.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.ioteventsdata.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * IoT Events monitors your equipment or device fleets for failures or changes in operation, and triggers actions when such events occur. You can use IoT Events Data API commands to send inputs to detectors, list detectors, and view or update a detector's status.
 *
 *  For more information, see [What is IoT Events?](https://docs.aws.amazon.com/iotevents/latest/developerguide/what-is-iotevents.html) in the *IoT Events Developer Guide*.
 */
interface IotEventsDataClient : SdkClient {

    override val serviceName: String
        get() = "IoT Events Data"
    /**
     * IotEventsDataClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): IotEventsDataClient {
            val config = Config.Builder().apply(block).build()
            return DefaultIotEventsDataClient(config)
        }

        operator fun invoke(config: Config): IotEventsDataClient = DefaultIotEventsDataClient(config)

        /**
         * Construct a [IotEventsDataClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): IotEventsDataClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultIotEventsDataClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Acknowledges one or more alarms. The alarms change to the `ACKNOWLEDGED` state after you acknowledge them.
     */
    suspend fun batchAcknowledgeAlarm(input: BatchAcknowledgeAlarmRequest): BatchAcknowledgeAlarmResponse

    /**
     * Acknowledges one or more alarms. The alarms change to the `ACKNOWLEDGED` state after you acknowledge them.
     */
    suspend fun batchAcknowledgeAlarm(block: BatchAcknowledgeAlarmRequest.Builder.() -> Unit) = batchAcknowledgeAlarm(BatchAcknowledgeAlarmRequest.Builder().apply(block).build())

    /**
     * Deletes one or more detectors that were created. When a detector is deleted, its state will be cleared and the detector will be removed from the list of detectors. The deleted detector will no longer appear if referenced in the [ListDetectors](https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_ListDetectors.html) API call.
     */
    suspend fun batchDeleteDetector(input: BatchDeleteDetectorRequest): BatchDeleteDetectorResponse

    /**
     * Deletes one or more detectors that were created. When a detector is deleted, its state will be cleared and the detector will be removed from the list of detectors. The deleted detector will no longer appear if referenced in the [ListDetectors](https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_ListDetectors.html) API call.
     */
    suspend fun batchDeleteDetector(block: BatchDeleteDetectorRequest.Builder.() -> Unit) = batchDeleteDetector(BatchDeleteDetectorRequest.Builder().apply(block).build())

    /**
     * Disables one or more alarms. The alarms change to the `DISABLED` state after you disable them.
     */
    suspend fun batchDisableAlarm(input: BatchDisableAlarmRequest): BatchDisableAlarmResponse

    /**
     * Disables one or more alarms. The alarms change to the `DISABLED` state after you disable them.
     */
    suspend fun batchDisableAlarm(block: BatchDisableAlarmRequest.Builder.() -> Unit) = batchDisableAlarm(BatchDisableAlarmRequest.Builder().apply(block).build())

    /**
     * Enables one or more alarms. The alarms change to the `NORMAL` state after you enable them.
     */
    suspend fun batchEnableAlarm(input: BatchEnableAlarmRequest): BatchEnableAlarmResponse

    /**
     * Enables one or more alarms. The alarms change to the `NORMAL` state after you enable them.
     */
    suspend fun batchEnableAlarm(block: BatchEnableAlarmRequest.Builder.() -> Unit) = batchEnableAlarm(BatchEnableAlarmRequest.Builder().apply(block).build())

    /**
     * Sends a set of messages to the IoT Events system. Each message payload is transformed into the input you specify (`"inputName"`) and ingested into any detectors that monitor that input. If multiple messages are sent, the order in which the messages are processed isn't guaranteed. To guarantee ordering, you must send messages one at a time and wait for a successful response.
     */
    suspend fun batchPutMessage(input: BatchPutMessageRequest): BatchPutMessageResponse

    /**
     * Sends a set of messages to the IoT Events system. Each message payload is transformed into the input you specify (`"inputName"`) and ingested into any detectors that monitor that input. If multiple messages are sent, the order in which the messages are processed isn't guaranteed. To guarantee ordering, you must send messages one at a time and wait for a successful response.
     */
    suspend fun batchPutMessage(block: BatchPutMessageRequest.Builder.() -> Unit) = batchPutMessage(BatchPutMessageRequest.Builder().apply(block).build())

    /**
     * Resets one or more alarms. The alarms return to the `NORMAL` state after you reset them.
     */
    suspend fun batchResetAlarm(input: BatchResetAlarmRequest): BatchResetAlarmResponse

    /**
     * Resets one or more alarms. The alarms return to the `NORMAL` state after you reset them.
     */
    suspend fun batchResetAlarm(block: BatchResetAlarmRequest.Builder.() -> Unit) = batchResetAlarm(BatchResetAlarmRequest.Builder().apply(block).build())

    /**
     * Changes one or more alarms to the snooze mode. The alarms change to the `SNOOZE_DISABLED` state after you set them to the snooze mode.
     */
    suspend fun batchSnoozeAlarm(input: BatchSnoozeAlarmRequest): BatchSnoozeAlarmResponse

    /**
     * Changes one or more alarms to the snooze mode. The alarms change to the `SNOOZE_DISABLED` state after you set them to the snooze mode.
     */
    suspend fun batchSnoozeAlarm(block: BatchSnoozeAlarmRequest.Builder.() -> Unit) = batchSnoozeAlarm(BatchSnoozeAlarmRequest.Builder().apply(block).build())

    /**
     * Updates the state, variable values, and timer settings of one or more detectors (instances) of a specified detector model.
     */
    suspend fun batchUpdateDetector(input: BatchUpdateDetectorRequest): BatchUpdateDetectorResponse

    /**
     * Updates the state, variable values, and timer settings of one or more detectors (instances) of a specified detector model.
     */
    suspend fun batchUpdateDetector(block: BatchUpdateDetectorRequest.Builder.() -> Unit) = batchUpdateDetector(BatchUpdateDetectorRequest.Builder().apply(block).build())

    /**
     * Retrieves information about an alarm.
     */
    suspend fun describeAlarm(input: DescribeAlarmRequest): DescribeAlarmResponse

    /**
     * Retrieves information about an alarm.
     */
    suspend fun describeAlarm(block: DescribeAlarmRequest.Builder.() -> Unit) = describeAlarm(DescribeAlarmRequest.Builder().apply(block).build())

    /**
     * Returns information about the specified detector (instance).
     */
    suspend fun describeDetector(input: DescribeDetectorRequest): DescribeDetectorResponse

    /**
     * Returns information about the specified detector (instance).
     */
    suspend fun describeDetector(block: DescribeDetectorRequest.Builder.() -> Unit) = describeDetector(DescribeDetectorRequest.Builder().apply(block).build())

    /**
     * Lists one or more alarms. The operation returns only the metadata associated with each alarm.
     */
    suspend fun listAlarms(input: ListAlarmsRequest): ListAlarmsResponse

    /**
     * Lists one or more alarms. The operation returns only the metadata associated with each alarm.
     */
    suspend fun listAlarms(block: ListAlarmsRequest.Builder.() -> Unit) = listAlarms(ListAlarmsRequest.Builder().apply(block).build())

    /**
     * Lists detectors (the instances of a detector model).
     */
    suspend fun listDetectors(input: ListDetectorsRequest): ListDetectorsResponse

    /**
     * Lists detectors (the instances of a detector model).
     */
    suspend fun listDetectors(block: ListDetectorsRequest.Builder.() -> Unit) = listDetectors(ListDetectorsRequest.Builder().apply(block).build())
}
