// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ioteventsdata.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about an alarm.
 */
class Alarm private constructor(builder: Builder) {
    /**
     * The name of the alarm model.
     */
    val alarmModelName: kotlin.String? = builder.alarmModelName
    /**
     * The version of the alarm model.
     */
    val alarmModelVersion: kotlin.String? = builder.alarmModelVersion
    /**
     * Contains information about the current state of the alarm.
     */
    val alarmState: aws.sdk.kotlin.services.ioteventsdata.model.AlarmState? = builder.alarmState
    /**
     * The time the alarm was created, in the Unix epoch format.
     */
    val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The value of the key used as a filter to select only the alarms associated with the [key](https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key).
     */
    val keyValue: kotlin.String? = builder.keyValue
    /**
     * The time the alarm was last updated, in the Unix epoch format.
     */
    val lastUpdateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdateTime
    /**
     * A non-negative integer that reflects the severity level of the alarm.
     */
    val severity: kotlin.Int? = builder.severity

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ioteventsdata.model.Alarm = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Alarm(")
        append("alarmModelName=$alarmModelName,")
        append("alarmModelVersion=$alarmModelVersion,")
        append("alarmState=$alarmState,")
        append("creationTime=$creationTime,")
        append("keyValue=$keyValue,")
        append("lastUpdateTime=$lastUpdateTime,")
        append("severity=$severity)")
    }

    override fun hashCode(): kotlin.Int {
        var result = alarmModelName?.hashCode() ?: 0
        result = 31 * result + (alarmModelVersion?.hashCode() ?: 0)
        result = 31 * result + (alarmState?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (keyValue?.hashCode() ?: 0)
        result = 31 * result + (lastUpdateTime?.hashCode() ?: 0)
        result = 31 * result + (severity ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Alarm

        if (alarmModelName != other.alarmModelName) return false
        if (alarmModelVersion != other.alarmModelVersion) return false
        if (alarmState != other.alarmState) return false
        if (creationTime != other.creationTime) return false
        if (keyValue != other.keyValue) return false
        if (lastUpdateTime != other.lastUpdateTime) return false
        if (severity != other.severity) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ioteventsdata.model.Alarm = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the alarm model.
         */
        var alarmModelName: kotlin.String? = null
        /**
         * The version of the alarm model.
         */
        var alarmModelVersion: kotlin.String? = null
        /**
         * Contains information about the current state of the alarm.
         */
        var alarmState: aws.sdk.kotlin.services.ioteventsdata.model.AlarmState? = null
        /**
         * The time the alarm was created, in the Unix epoch format.
         */
        var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The value of the key used as a filter to select only the alarms associated with the [key](https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key).
         */
        var keyValue: kotlin.String? = null
        /**
         * The time the alarm was last updated, in the Unix epoch format.
         */
        var lastUpdateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A non-negative integer that reflects the severity level of the alarm.
         */
        var severity: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ioteventsdata.model.Alarm) : this() {
            this.alarmModelName = x.alarmModelName
            this.alarmModelVersion = x.alarmModelVersion
            this.alarmState = x.alarmState
            this.creationTime = x.creationTime
            this.keyValue = x.keyValue
            this.lastUpdateTime = x.lastUpdateTime
            this.severity = x.severity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ioteventsdata.model.Alarm = Alarm(this)

        /**
         * construct an [aws.sdk.kotlin.services.ioteventsdata.model.AlarmState] inside the given [block]
         */
        fun alarmState(block: aws.sdk.kotlin.services.ioteventsdata.model.AlarmState.Builder.() -> kotlin.Unit) {
            this.alarmState = aws.sdk.kotlin.services.ioteventsdata.model.AlarmState.invoke(block)
        }
    }
}
