// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ioteventsdata.model



/**
 * Contains information about the current state of the alarm.
 */
class AlarmState private constructor(builder: Builder) {
    /**
     * Contains information about the action that you can take to respond to the alarm.
     */
    val customerAction: aws.sdk.kotlin.services.ioteventsdata.model.CustomerAction? = builder.customerAction
    /**
     * Information needed to evaluate data.
     */
    val ruleEvaluation: aws.sdk.kotlin.services.ioteventsdata.model.RuleEvaluation? = builder.ruleEvaluation
    /**
     * The name of the alarm state. The state name can be one of the following values:
     * + `DISABLED` - When the alarm is in the `DISABLED` state, it isn't ready to evaluate data. To enable the alarm, you must change the alarm to the `NORMAL` state.
     * + `NORMAL` - When the alarm is in the `NORMAL` state, it's ready to evaluate data.
     * + `ACTIVE` - If the alarm is in the `ACTIVE` state, the alarm is invoked.
     * + `ACKNOWLEDGED` - When the alarm is in the `ACKNOWLEDGED` state, the alarm was invoked and you acknowledged the alarm.
     * + `SNOOZE_DISABLED` - When the alarm is in the `SNOOZE_DISABLED` state, the alarm is disabled for a specified period of time. After the snooze time, the alarm automatically changes to the `NORMAL` state.
     * + `LATCHED` - When the alarm is in the `LATCHED` state, the alarm was invoked. However, the data that the alarm is currently evaluating is within the specified range. To change the alarm to the `NORMAL` state, you must acknowledge the alarm.
     */
    val stateName: aws.sdk.kotlin.services.ioteventsdata.model.AlarmStateName? = builder.stateName
    /**
     * Contains information about alarm state changes.
     */
    val systemEvent: aws.sdk.kotlin.services.ioteventsdata.model.SystemEvent? = builder.systemEvent

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ioteventsdata.model.AlarmState = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AlarmState(")
        append("customerAction=$customerAction,")
        append("ruleEvaluation=$ruleEvaluation,")
        append("stateName=$stateName,")
        append("systemEvent=$systemEvent)")
    }

    override fun hashCode(): kotlin.Int {
        var result = customerAction?.hashCode() ?: 0
        result = 31 * result + (ruleEvaluation?.hashCode() ?: 0)
        result = 31 * result + (stateName?.hashCode() ?: 0)
        result = 31 * result + (systemEvent?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AlarmState

        if (customerAction != other.customerAction) return false
        if (ruleEvaluation != other.ruleEvaluation) return false
        if (stateName != other.stateName) return false
        if (systemEvent != other.systemEvent) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ioteventsdata.model.AlarmState = Builder(this).apply(block).build()

    class Builder {
        /**
         * Contains information about the action that you can take to respond to the alarm.
         */
        var customerAction: aws.sdk.kotlin.services.ioteventsdata.model.CustomerAction? = null
        /**
         * Information needed to evaluate data.
         */
        var ruleEvaluation: aws.sdk.kotlin.services.ioteventsdata.model.RuleEvaluation? = null
        /**
         * The name of the alarm state. The state name can be one of the following values:
         * + `DISABLED` - When the alarm is in the `DISABLED` state, it isn't ready to evaluate data. To enable the alarm, you must change the alarm to the `NORMAL` state.
         * + `NORMAL` - When the alarm is in the `NORMAL` state, it's ready to evaluate data.
         * + `ACTIVE` - If the alarm is in the `ACTIVE` state, the alarm is invoked.
         * + `ACKNOWLEDGED` - When the alarm is in the `ACKNOWLEDGED` state, the alarm was invoked and you acknowledged the alarm.
         * + `SNOOZE_DISABLED` - When the alarm is in the `SNOOZE_DISABLED` state, the alarm is disabled for a specified period of time. After the snooze time, the alarm automatically changes to the `NORMAL` state.
         * + `LATCHED` - When the alarm is in the `LATCHED` state, the alarm was invoked. However, the data that the alarm is currently evaluating is within the specified range. To change the alarm to the `NORMAL` state, you must acknowledge the alarm.
         */
        var stateName: aws.sdk.kotlin.services.ioteventsdata.model.AlarmStateName? = null
        /**
         * Contains information about alarm state changes.
         */
        var systemEvent: aws.sdk.kotlin.services.ioteventsdata.model.SystemEvent? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ioteventsdata.model.AlarmState) : this() {
            this.customerAction = x.customerAction
            this.ruleEvaluation = x.ruleEvaluation
            this.stateName = x.stateName
            this.systemEvent = x.systemEvent
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ioteventsdata.model.AlarmState = AlarmState(this)

        /**
         * construct an [aws.sdk.kotlin.services.ioteventsdata.model.CustomerAction] inside the given [block]
         */
        fun customerAction(block: aws.sdk.kotlin.services.ioteventsdata.model.CustomerAction.Builder.() -> kotlin.Unit) {
            this.customerAction = aws.sdk.kotlin.services.ioteventsdata.model.CustomerAction.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ioteventsdata.model.RuleEvaluation] inside the given [block]
         */
        fun ruleEvaluation(block: aws.sdk.kotlin.services.ioteventsdata.model.RuleEvaluation.Builder.() -> kotlin.Unit) {
            this.ruleEvaluation = aws.sdk.kotlin.services.ioteventsdata.model.RuleEvaluation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ioteventsdata.model.SystemEvent] inside the given [block]
         */
        fun systemEvent(block: aws.sdk.kotlin.services.ioteventsdata.model.SystemEvent.Builder.() -> kotlin.Unit) {
            this.systemEvent = aws.sdk.kotlin.services.ioteventsdata.model.SystemEvent.invoke(block)
        }
    }
}
