// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ioteventsdata.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains a summary of an alarm.
 */
class AlarmSummary private constructor(builder: Builder) {
    /**
     * The name of the alarm model.
     */
    val alarmModelName: kotlin.String? = builder.alarmModelName
    /**
     * The version of the alarm model.
     */
    val alarmModelVersion: kotlin.String? = builder.alarmModelVersion
    /**
     * The time the alarm was created, in the Unix epoch format.
     */
    val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The value of the key used as a filter to select only the alarms associated with the [key](https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key).
     */
    val keyValue: kotlin.String? = builder.keyValue
    /**
     * The time the alarm was last updated, in the Unix epoch format.
     */
    val lastUpdateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdateTime
    /**
     * The name of the alarm state. The state name can be one of the following values:
     * + `DISABLED` - When the alarm is in the `DISABLED` state, it isn't ready to evaluate data. To enable the alarm, you must change the alarm to the `NORMAL` state.
     * + `NORMAL` - When the alarm is in the `NORMAL` state, it's ready to evaluate data.
     * + `ACTIVE` - If the alarm is in the `ACTIVE` state, the alarm is invoked.
     * + `ACKNOWLEDGED` - When the alarm is in the `ACKNOWLEDGED` state, the alarm was invoked and you acknowledged the alarm.
     * + `SNOOZE_DISABLED` - When the alarm is in the `SNOOZE_DISABLED` state, the alarm is disabled for a specified period of time. After the snooze time, the alarm automatically changes to the `NORMAL` state.
     * + `LATCHED` - When the alarm is in the `LATCHED` state, the alarm was invoked. However, the data that the alarm is currently evaluating is within the specified range. To change the alarm to the `NORMAL` state, you must acknowledge the alarm.
     */
    val stateName: aws.sdk.kotlin.services.ioteventsdata.model.AlarmStateName? = builder.stateName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ioteventsdata.model.AlarmSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AlarmSummary(")
        append("alarmModelName=$alarmModelName,")
        append("alarmModelVersion=$alarmModelVersion,")
        append("creationTime=$creationTime,")
        append("keyValue=$keyValue,")
        append("lastUpdateTime=$lastUpdateTime,")
        append("stateName=$stateName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = alarmModelName?.hashCode() ?: 0
        result = 31 * result + (alarmModelVersion?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (keyValue?.hashCode() ?: 0)
        result = 31 * result + (lastUpdateTime?.hashCode() ?: 0)
        result = 31 * result + (stateName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AlarmSummary

        if (alarmModelName != other.alarmModelName) return false
        if (alarmModelVersion != other.alarmModelVersion) return false
        if (creationTime != other.creationTime) return false
        if (keyValue != other.keyValue) return false
        if (lastUpdateTime != other.lastUpdateTime) return false
        if (stateName != other.stateName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ioteventsdata.model.AlarmSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the alarm model.
         */
        var alarmModelName: kotlin.String? = null
        /**
         * The version of the alarm model.
         */
        var alarmModelVersion: kotlin.String? = null
        /**
         * The time the alarm was created, in the Unix epoch format.
         */
        var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The value of the key used as a filter to select only the alarms associated with the [key](https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key).
         */
        var keyValue: kotlin.String? = null
        /**
         * The time the alarm was last updated, in the Unix epoch format.
         */
        var lastUpdateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the alarm state. The state name can be one of the following values:
         * + `DISABLED` - When the alarm is in the `DISABLED` state, it isn't ready to evaluate data. To enable the alarm, you must change the alarm to the `NORMAL` state.
         * + `NORMAL` - When the alarm is in the `NORMAL` state, it's ready to evaluate data.
         * + `ACTIVE` - If the alarm is in the `ACTIVE` state, the alarm is invoked.
         * + `ACKNOWLEDGED` - When the alarm is in the `ACKNOWLEDGED` state, the alarm was invoked and you acknowledged the alarm.
         * + `SNOOZE_DISABLED` - When the alarm is in the `SNOOZE_DISABLED` state, the alarm is disabled for a specified period of time. After the snooze time, the alarm automatically changes to the `NORMAL` state.
         * + `LATCHED` - When the alarm is in the `LATCHED` state, the alarm was invoked. However, the data that the alarm is currently evaluating is within the specified range. To change the alarm to the `NORMAL` state, you must acknowledge the alarm.
         */
        var stateName: aws.sdk.kotlin.services.ioteventsdata.model.AlarmStateName? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ioteventsdata.model.AlarmSummary) : this() {
            this.alarmModelName = x.alarmModelName
            this.alarmModelVersion = x.alarmModelVersion
            this.creationTime = x.creationTime
            this.keyValue = x.keyValue
            this.lastUpdateTime = x.lastUpdateTime
            this.stateName = x.stateName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ioteventsdata.model.AlarmSummary = AlarmSummary(this)
    }
}
