// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ioteventsdata.model



/**
 * Contains information about the action that you can take to respond to the alarm.
 */
class CustomerAction private constructor(builder: Builder) {
    /**
     * Contains the configuration information of an acknowledge action.
     */
    val acknowledgeActionConfiguration: aws.sdk.kotlin.services.ioteventsdata.model.AcknowledgeActionConfiguration? = builder.acknowledgeActionConfiguration
    /**
     * The name of the action. The action name can be one of the following values:
     * + `SNOOZE` - When you snooze the alarm, the alarm state changes to `SNOOZE_DISABLED`.
     * + `ENABLE` - When you enable the alarm, the alarm state changes to `NORMAL`.
     * + `DISABLE` - When you disable the alarm, the alarm state changes to `DISABLED`.
     * + `ACKNOWLEDGE` - When you acknowledge the alarm, the alarm state changes to `ACKNOWLEDGED`.
     * + `RESET` - When you reset the alarm, the alarm state changes to `NORMAL`.
     *
     * For more information, see the [AlarmState](https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_AlarmState.html) API.
     */
    val actionName: aws.sdk.kotlin.services.ioteventsdata.model.CustomerActionName? = builder.actionName
    /**
     * Contains the configuration information of a disable action.
     */
    val disableActionConfiguration: aws.sdk.kotlin.services.ioteventsdata.model.DisableActionConfiguration? = builder.disableActionConfiguration
    /**
     * Contains the configuration information of an enable action.
     */
    val enableActionConfiguration: aws.sdk.kotlin.services.ioteventsdata.model.EnableActionConfiguration? = builder.enableActionConfiguration
    /**
     * Contains the configuration information of a reset action.
     */
    val resetActionConfiguration: aws.sdk.kotlin.services.ioteventsdata.model.ResetActionConfiguration? = builder.resetActionConfiguration
    /**
     * Contains the configuration information of a snooze action.
     */
    val snoozeActionConfiguration: aws.sdk.kotlin.services.ioteventsdata.model.SnoozeActionConfiguration? = builder.snoozeActionConfiguration

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ioteventsdata.model.CustomerAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CustomerAction(")
        append("acknowledgeActionConfiguration=$acknowledgeActionConfiguration,")
        append("actionName=$actionName,")
        append("disableActionConfiguration=$disableActionConfiguration,")
        append("enableActionConfiguration=$enableActionConfiguration,")
        append("resetActionConfiguration=$resetActionConfiguration,")
        append("snoozeActionConfiguration=$snoozeActionConfiguration)")
    }

    override fun hashCode(): kotlin.Int {
        var result = acknowledgeActionConfiguration?.hashCode() ?: 0
        result = 31 * result + (actionName?.hashCode() ?: 0)
        result = 31 * result + (disableActionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (enableActionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (resetActionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (snoozeActionConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CustomerAction

        if (acknowledgeActionConfiguration != other.acknowledgeActionConfiguration) return false
        if (actionName != other.actionName) return false
        if (disableActionConfiguration != other.disableActionConfiguration) return false
        if (enableActionConfiguration != other.enableActionConfiguration) return false
        if (resetActionConfiguration != other.resetActionConfiguration) return false
        if (snoozeActionConfiguration != other.snoozeActionConfiguration) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ioteventsdata.model.CustomerAction = Builder(this).apply(block).build()

    class Builder {
        /**
         * Contains the configuration information of an acknowledge action.
         */
        var acknowledgeActionConfiguration: aws.sdk.kotlin.services.ioteventsdata.model.AcknowledgeActionConfiguration? = null
        /**
         * The name of the action. The action name can be one of the following values:
         * + `SNOOZE` - When you snooze the alarm, the alarm state changes to `SNOOZE_DISABLED`.
         * + `ENABLE` - When you enable the alarm, the alarm state changes to `NORMAL`.
         * + `DISABLE` - When you disable the alarm, the alarm state changes to `DISABLED`.
         * + `ACKNOWLEDGE` - When you acknowledge the alarm, the alarm state changes to `ACKNOWLEDGED`.
         * + `RESET` - When you reset the alarm, the alarm state changes to `NORMAL`.
         *
         * For more information, see the [AlarmState](https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_AlarmState.html) API.
         */
        var actionName: aws.sdk.kotlin.services.ioteventsdata.model.CustomerActionName? = null
        /**
         * Contains the configuration information of a disable action.
         */
        var disableActionConfiguration: aws.sdk.kotlin.services.ioteventsdata.model.DisableActionConfiguration? = null
        /**
         * Contains the configuration information of an enable action.
         */
        var enableActionConfiguration: aws.sdk.kotlin.services.ioteventsdata.model.EnableActionConfiguration? = null
        /**
         * Contains the configuration information of a reset action.
         */
        var resetActionConfiguration: aws.sdk.kotlin.services.ioteventsdata.model.ResetActionConfiguration? = null
        /**
         * Contains the configuration information of a snooze action.
         */
        var snoozeActionConfiguration: aws.sdk.kotlin.services.ioteventsdata.model.SnoozeActionConfiguration? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ioteventsdata.model.CustomerAction) : this() {
            this.acknowledgeActionConfiguration = x.acknowledgeActionConfiguration
            this.actionName = x.actionName
            this.disableActionConfiguration = x.disableActionConfiguration
            this.enableActionConfiguration = x.enableActionConfiguration
            this.resetActionConfiguration = x.resetActionConfiguration
            this.snoozeActionConfiguration = x.snoozeActionConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ioteventsdata.model.CustomerAction = CustomerAction(this)

        /**
         * construct an [aws.sdk.kotlin.services.ioteventsdata.model.AcknowledgeActionConfiguration] inside the given [block]
         */
        fun acknowledgeActionConfiguration(block: aws.sdk.kotlin.services.ioteventsdata.model.AcknowledgeActionConfiguration.Builder.() -> kotlin.Unit) {
            this.acknowledgeActionConfiguration = aws.sdk.kotlin.services.ioteventsdata.model.AcknowledgeActionConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ioteventsdata.model.DisableActionConfiguration] inside the given [block]
         */
        fun disableActionConfiguration(block: aws.sdk.kotlin.services.ioteventsdata.model.DisableActionConfiguration.Builder.() -> kotlin.Unit) {
            this.disableActionConfiguration = aws.sdk.kotlin.services.ioteventsdata.model.DisableActionConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ioteventsdata.model.EnableActionConfiguration] inside the given [block]
         */
        fun enableActionConfiguration(block: aws.sdk.kotlin.services.ioteventsdata.model.EnableActionConfiguration.Builder.() -> kotlin.Unit) {
            this.enableActionConfiguration = aws.sdk.kotlin.services.ioteventsdata.model.EnableActionConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ioteventsdata.model.ResetActionConfiguration] inside the given [block]
         */
        fun resetActionConfiguration(block: aws.sdk.kotlin.services.ioteventsdata.model.ResetActionConfiguration.Builder.() -> kotlin.Unit) {
            this.resetActionConfiguration = aws.sdk.kotlin.services.ioteventsdata.model.ResetActionConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ioteventsdata.model.SnoozeActionConfiguration] inside the given [block]
         */
        fun snoozeActionConfiguration(block: aws.sdk.kotlin.services.ioteventsdata.model.SnoozeActionConfiguration.Builder.() -> kotlin.Unit) {
            this.snoozeActionConfiguration = aws.sdk.kotlin.services.ioteventsdata.model.SnoozeActionConfiguration.invoke(block)
        }
    }
}
