// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ioteventsdata.model



/**
 * Information about a message.
 */
class Message private constructor(builder: Builder) {
    /**
     * The name of the input into which the message payload is transformed.
     */
    val inputName: kotlin.String? = builder.inputName
    /**
     * The ID to assign to the message. Within each batch sent, each `"messageId"` must be unique.
     */
    val messageId: kotlin.String? = builder.messageId
    /**
     * The payload of the message. This can be a JSON string or a Base-64-encoded string representing binary data (in which case you must decode it).
     */
    val payload: kotlin.ByteArray? = builder.payload
    /**
     * The timestamp associated with the message.
     */
    val timestamp: aws.sdk.kotlin.services.ioteventsdata.model.TimestampValue? = builder.timestamp

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ioteventsdata.model.Message = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Message(")
        append("inputName=$inputName,")
        append("messageId=$messageId,")
        append("payload=$payload,")
        append("timestamp=$timestamp)")
    }

    override fun hashCode(): kotlin.Int {
        var result = inputName?.hashCode() ?: 0
        result = 31 * result + (messageId?.hashCode() ?: 0)
        result = 31 * result + (payload?.contentHashCode() ?: 0)
        result = 31 * result + (timestamp?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Message

        if (inputName != other.inputName) return false
        if (messageId != other.messageId) return false
        if (payload != null) {
            if (other.payload == null) return false
            if (!payload.contentEquals(other.payload)) return false
        } else if (other.payload != null) return false
        if (timestamp != other.timestamp) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ioteventsdata.model.Message = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the input into which the message payload is transformed.
         */
        var inputName: kotlin.String? = null
        /**
         * The ID to assign to the message. Within each batch sent, each `"messageId"` must be unique.
         */
        var messageId: kotlin.String? = null
        /**
         * The payload of the message. This can be a JSON string or a Base-64-encoded string representing binary data (in which case you must decode it).
         */
        var payload: kotlin.ByteArray? = null
        /**
         * The timestamp associated with the message.
         */
        var timestamp: aws.sdk.kotlin.services.ioteventsdata.model.TimestampValue? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ioteventsdata.model.Message) : this() {
            this.inputName = x.inputName
            this.messageId = x.messageId
            this.payload = x.payload
            this.timestamp = x.timestamp
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ioteventsdata.model.Message = Message(this)

        /**
         * construct an [aws.sdk.kotlin.services.ioteventsdata.model.TimestampValue] inside the given [block]
         */
        fun timestamp(block: aws.sdk.kotlin.services.ioteventsdata.model.TimestampValue.Builder.() -> kotlin.Unit) {
            this.timestamp = aws.sdk.kotlin.services.ioteventsdata.model.TimestampValue.invoke(block)
        }
    }
}
