// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ioteventsdata.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.ioteventsdata.model.BatchUpdateDetectorErrorEntry
import aws.sdk.kotlin.services.ioteventsdata.model.BatchUpdateDetectorResponse
import aws.sdk.kotlin.services.ioteventsdata.model.IotEventsDataException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class BatchUpdateDetectorOperationDeserializer: HttpDeserialize<BatchUpdateDetectorResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): BatchUpdateDetectorResponse {
        if (!response.status.isSuccess()) {
            throwBatchUpdateDetectorError(context, response)
        }
        val builder = BatchUpdateDetectorResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeBatchUpdateDetectorOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwBatchUpdateDetectorError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IotEventsDataException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IotEventsDataException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchUpdateDetectorOperationBody(builder: BatchUpdateDetectorResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BATCHUPDATEDETECTORERRORENTRIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("batchUpdateDetectorErrorEntries"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BATCHUPDATEDETECTORERRORENTRIES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BATCHUPDATEDETECTORERRORENTRIES_DESCRIPTOR.index -> builder.batchUpdateDetectorErrorEntries =
                    deserializer.deserializeList(BATCHUPDATEDETECTORERRORENTRIES_DESCRIPTOR) {
                        val col0 = mutableListOf<BatchUpdateDetectorErrorEntry>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBatchUpdateDetectorErrorEntryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
