// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotfleethub

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.iotfleethub.model.*
import aws.sdk.kotlin.services.iotfleethub.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "IoTFleetHub"
const val ServiceApiVersion: String = "2020-11-03"
const val SdkVersion: String = "0.16.6-beta"

internal class DefaultIoTFleetHubClient(override val config: IoTFleetHubClient.Config) : IoTFleetHubClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Creates a Fleet Hub for AWS IoT Device Management web application.
     *
     * Fleet Hub for AWS IoT Device Management is in public preview and is subject to change.
     */
    override suspend fun createApplication(input: CreateApplicationRequest): CreateApplicationResponse {
        val op = SdkHttpOperation.build<CreateApplicationRequest, CreateApplicationResponse> {
            serializer = CreateApplicationOperationSerializer()
            deserializer = CreateApplicationOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateApplication"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleethub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a Fleet Hub for AWS IoT Device Management web application.
     *
     * Fleet Hub for AWS IoT Device Management is in public preview and is subject to change.
     */
    override suspend fun deleteApplication(input: DeleteApplicationRequest): DeleteApplicationResponse {
        val op = SdkHttpOperation.build<DeleteApplicationRequest, DeleteApplicationResponse> {
            serializer = DeleteApplicationOperationSerializer()
            deserializer = DeleteApplicationOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "DeleteApplication"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleethub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a Fleet Hub for AWS IoT Device Management web application.
     *
     * Fleet Hub for AWS IoT Device Management is in public preview and is subject to change.
     */
    override suspend fun describeApplication(input: DescribeApplicationRequest): DescribeApplicationResponse {
        val op = SdkHttpOperation.build<DescribeApplicationRequest, DescribeApplicationResponse> {
            serializer = DescribeApplicationOperationSerializer()
            deserializer = DescribeApplicationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeApplication"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleethub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of Fleet Hub for AWS IoT Device Management web applications for the current account.
     *
     * Fleet Hub for AWS IoT Device Management is in public preview and is subject to change.
     */
    override suspend fun listApplications(input: ListApplicationsRequest): ListApplicationsResponse {
        val op = SdkHttpOperation.build<ListApplicationsRequest, ListApplicationsResponse> {
            serializer = ListApplicationsOperationSerializer()
            deserializer = ListApplicationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListApplications"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleethub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the tags for the specified resource.
     *
     * Fleet Hub for AWS IoT Device Management is in public preview and is subject to change.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleethub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds to or modifies the tags of the specified resource. Tags are metadata which can be used to manage a resource.
     *
     * Fleet Hub for AWS IoT Device Management is in public preview and is subject to change.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleethub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes the specified tags (metadata) from the resource.
     *
     * Fleet Hub for AWS IoT Device Management is in public preview and is subject to change.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleethub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates information about a Fleet Hub for a AWS IoT Device Management web application.
     *
     * Fleet Hub for AWS IoT Device Management is in public preview and is subject to change.
     */
    override suspend fun updateApplication(input: UpdateApplicationRequest): UpdateApplicationResponse {
        val op = SdkHttpOperation.build<UpdateApplicationRequest, UpdateApplicationResponse> {
            serializer = UpdateApplicationOperationSerializer()
            deserializer = UpdateApplicationOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "UpdateApplication"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleethub"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "iotfleethub")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
