// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotfleethub.model



/**
 * A summary of information about a AWS IoT Device Management web application.
 * Fleet Hub for AWS IoT Device Management is in public preview and is subject to change.
 */
class ApplicationSummary private constructor(builder: Builder) {
    /**
     * The date (in Unix epoch time) when the web application was created.
     */
    val applicationCreationDate: kotlin.Long = builder.applicationCreationDate
    /**
     * An optional description of the web application.
     */
    val applicationDescription: kotlin.String? = builder.applicationDescription
    /**
     * The unique Id of the web application.
     */
    val applicationId: kotlin.String? = builder.applicationId
    /**
     * The date (in Unix epoch time) when the web application was last updated.
     */
    val applicationLastUpdateDate: kotlin.Long = builder.applicationLastUpdateDate
    /**
     * The name of the web application.
     */
    val applicationName: kotlin.String? = builder.applicationName
    /**
     * The current state of the web application.
     */
    val applicationState: aws.sdk.kotlin.services.iotfleethub.model.ApplicationState? = builder.applicationState
    /**
     * The URL of the web application.
     */
    val applicationUrl: kotlin.String? = builder.applicationUrl

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotfleethub.model.ApplicationSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ApplicationSummary(")
        append("applicationCreationDate=$applicationCreationDate,")
        append("applicationDescription=$applicationDescription,")
        append("applicationId=$applicationId,")
        append("applicationLastUpdateDate=$applicationLastUpdateDate,")
        append("applicationName=$applicationName,")
        append("applicationState=$applicationState,")
        append("applicationUrl=$applicationUrl)")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationCreationDate.hashCode()
        result = 31 * result + (applicationDescription?.hashCode() ?: 0)
        result = 31 * result + (applicationId?.hashCode() ?: 0)
        result = 31 * result + (applicationLastUpdateDate.hashCode())
        result = 31 * result + (applicationName?.hashCode() ?: 0)
        result = 31 * result + (applicationState?.hashCode() ?: 0)
        result = 31 * result + (applicationUrl?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ApplicationSummary

        if (applicationCreationDate != other.applicationCreationDate) return false
        if (applicationDescription != other.applicationDescription) return false
        if (applicationId != other.applicationId) return false
        if (applicationLastUpdateDate != other.applicationLastUpdateDate) return false
        if (applicationName != other.applicationName) return false
        if (applicationState != other.applicationState) return false
        if (applicationUrl != other.applicationUrl) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotfleethub.model.ApplicationSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * The date (in Unix epoch time) when the web application was created.
         */
        var applicationCreationDate: kotlin.Long = 0L
        /**
         * An optional description of the web application.
         */
        var applicationDescription: kotlin.String? = null
        /**
         * The unique Id of the web application.
         */
        var applicationId: kotlin.String? = null
        /**
         * The date (in Unix epoch time) when the web application was last updated.
         */
        var applicationLastUpdateDate: kotlin.Long = 0L
        /**
         * The name of the web application.
         */
        var applicationName: kotlin.String? = null
        /**
         * The current state of the web application.
         */
        var applicationState: aws.sdk.kotlin.services.iotfleethub.model.ApplicationState? = null
        /**
         * The URL of the web application.
         */
        var applicationUrl: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotfleethub.model.ApplicationSummary) : this() {
            this.applicationCreationDate = x.applicationCreationDate
            this.applicationDescription = x.applicationDescription
            this.applicationId = x.applicationId
            this.applicationLastUpdateDate = x.applicationLastUpdateDate
            this.applicationName = x.applicationName
            this.applicationState = x.applicationState
            this.applicationUrl = x.applicationUrl
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotfleethub.model.ApplicationSummary = ApplicationSummary(this)
    }
}
