// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsecuretunneling

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.iotsecuretunneling.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.iotsecuretunneling.model.*
import aws.sdk.kotlin.services.iotsecuretunneling.model.CloseTunnelRequest
import aws.sdk.kotlin.services.iotsecuretunneling.model.CloseTunnelResponse
import aws.sdk.kotlin.services.iotsecuretunneling.model.DescribeTunnelRequest
import aws.sdk.kotlin.services.iotsecuretunneling.model.DescribeTunnelResponse
import aws.sdk.kotlin.services.iotsecuretunneling.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.iotsecuretunneling.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.iotsecuretunneling.model.ListTunnelsRequest
import aws.sdk.kotlin.services.iotsecuretunneling.model.ListTunnelsResponse
import aws.sdk.kotlin.services.iotsecuretunneling.model.OpenTunnelRequest
import aws.sdk.kotlin.services.iotsecuretunneling.model.OpenTunnelResponse
import aws.sdk.kotlin.services.iotsecuretunneling.model.RotateTunnelAccessTokenRequest
import aws.sdk.kotlin.services.iotsecuretunneling.model.RotateTunnelAccessTokenResponse
import aws.sdk.kotlin.services.iotsecuretunneling.model.TagResourceRequest
import aws.sdk.kotlin.services.iotsecuretunneling.model.TagResourceResponse
import aws.sdk.kotlin.services.iotsecuretunneling.model.UntagResourceRequest
import aws.sdk.kotlin.services.iotsecuretunneling.model.UntagResourceResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * # IoT Secure Tunneling
 * IoT Secure Tunneling creates remote connections to devices deployed in the field.
 *
 * For more information about how IoT Secure Tunneling works, see [IoT Secure Tunneling](https://docs.aws.amazon.com/iot/latest/developerguide/secure-tunneling.html).
 */
public interface IoTSecureTunnelingClient : SdkClient {

    override val serviceName: String
        get() = "IoTSecureTunneling"
    /**
     * IoTSecureTunnelingClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): IoTSecureTunnelingClient {
            val config = Config.Builder().apply(block).build()
            return DefaultIoTSecureTunnelingClient(config)
        }

        public operator fun invoke(config: Config): IoTSecureTunnelingClient = DefaultIoTSecureTunnelingClient(config)

        /**
         * Construct a [IoTSecureTunnelingClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): IoTSecureTunnelingClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultIoTSecureTunnelingClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Closes a tunnel identified by the unique tunnel id. When a `CloseTunnel` request is received, we close the WebSocket connections between the client and proxy server so no data can be transmitted.
     *
     * Requires permission to access the [CloseTunnel](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun closeTunnel(input: CloseTunnelRequest): CloseTunnelResponse

    /**
     * Gets information about a tunnel identified by the unique tunnel id.
     *
     * Requires permission to access the [DescribeTunnel](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun describeTunnel(input: DescribeTunnelRequest): DescribeTunnelResponse

    /**
     * Lists the tags for the specified resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * List all tunnels for an Amazon Web Services account. Tunnels are listed by creation time in descending order, newer tunnels will be listed before older tunnels.
     *
     * Requires permission to access the [ListTunnels](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun listTunnels(input: ListTunnelsRequest = ListTunnelsRequest {}): ListTunnelsResponse

    /**
     * Creates a new tunnel, and returns two client access tokens for clients to use to connect to the IoT Secure Tunneling proxy server.
     *
     * Requires permission to access the [OpenTunnel](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     */
    public suspend fun openTunnel(input: OpenTunnelRequest = OpenTunnelRequest {}): OpenTunnelResponse

    /**
     * Revokes the current client access token (CAT) and returns new CAT for clients to use when reconnecting to secure tunneling to access the same tunnel.
     *
     * Requires permission to access the [RotateTunnelAccessToken](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
     *
     * Rotating the CAT doesn't extend the tunnel duration. For example, say the tunnel duration is 12 hours and the tunnel has already been open for 4 hours. When you rotate the access tokens, the new tokens that are generated can only be used for the remaining 8 hours.
     */
    public suspend fun rotateTunnelAccessToken(input: RotateTunnelAccessTokenRequest): RotateTunnelAccessTokenResponse

    /**
     * A resource tag.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes a tag from a resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse
}

/**
 * Closes a tunnel identified by the unique tunnel id. When a `CloseTunnel` request is received, we close the WebSocket connections between the client and proxy server so no data can be transmitted.
 *
 * Requires permission to access the [CloseTunnel](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IoTSecureTunnelingClient.closeTunnel(crossinline block: CloseTunnelRequest.Builder.() -> Unit): CloseTunnelResponse = closeTunnel(CloseTunnelRequest.Builder().apply(block).build())

/**
 * Gets information about a tunnel identified by the unique tunnel id.
 *
 * Requires permission to access the [DescribeTunnel](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IoTSecureTunnelingClient.describeTunnel(crossinline block: DescribeTunnelRequest.Builder.() -> Unit): DescribeTunnelResponse = describeTunnel(DescribeTunnelRequest.Builder().apply(block).build())

/**
 * Lists the tags for the specified resource.
 */
public suspend inline fun IoTSecureTunnelingClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * List all tunnels for an Amazon Web Services account. Tunnels are listed by creation time in descending order, newer tunnels will be listed before older tunnels.
 *
 * Requires permission to access the [ListTunnels](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IoTSecureTunnelingClient.listTunnels(crossinline block: ListTunnelsRequest.Builder.() -> Unit): ListTunnelsResponse = listTunnels(ListTunnelsRequest.Builder().apply(block).build())

/**
 * Creates a new tunnel, and returns two client access tokens for clients to use to connect to the IoT Secure Tunneling proxy server.
 *
 * Requires permission to access the [OpenTunnel](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 */
public suspend inline fun IoTSecureTunnelingClient.openTunnel(crossinline block: OpenTunnelRequest.Builder.() -> Unit): OpenTunnelResponse = openTunnel(OpenTunnelRequest.Builder().apply(block).build())

/**
 * Revokes the current client access token (CAT) and returns new CAT for clients to use when reconnecting to secure tunneling to access the same tunnel.
 *
 * Requires permission to access the [RotateTunnelAccessToken](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 *
 * Rotating the CAT doesn't extend the tunnel duration. For example, say the tunnel duration is 12 hours and the tunnel has already been open for 4 hours. When you rotate the access tokens, the new tokens that are generated can only be used for the remaining 8 hours.
 */
public suspend inline fun IoTSecureTunnelingClient.rotateTunnelAccessToken(crossinline block: RotateTunnelAccessTokenRequest.Builder.() -> Unit): RotateTunnelAccessTokenResponse = rotateTunnelAccessToken(RotateTunnelAccessTokenRequest.Builder().apply(block).build())

/**
 * A resource tag.
 */
public suspend inline fun IoTSecureTunnelingClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes a tag from a resource.
 */
public suspend inline fun IoTSecureTunnelingClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())
