// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsecuretunneling.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A connection between a source computer and a destination device.
 */
public class Tunnel private constructor(builder: Builder) {
    /**
     * The time when the tunnel was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * A description of the tunnel.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The destination configuration that specifies the thing name of the destination device and a service name that the local proxy uses to connect to the destination application.
     */
    public val destinationConfig: aws.sdk.kotlin.services.iotsecuretunneling.model.DestinationConfig? = builder.destinationConfig
    /**
     * The connection state of the destination application.
     */
    public val destinationConnectionState: aws.sdk.kotlin.services.iotsecuretunneling.model.ConnectionState? = builder.destinationConnectionState
    /**
     * The last time the tunnel was updated.
     */
    public val lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedAt
    /**
     * The connection state of the source application.
     */
    public val sourceConnectionState: aws.sdk.kotlin.services.iotsecuretunneling.model.ConnectionState? = builder.sourceConnectionState
    /**
     * The status of a tunnel. Valid values are: Open and Closed.
     */
    public val status: aws.sdk.kotlin.services.iotsecuretunneling.model.TunnelStatus? = builder.status
    /**
     * A list of tag metadata associated with the secure tunnel.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * Timeout configuration for the tunnel.
     */
    public val timeoutConfig: aws.sdk.kotlin.services.iotsecuretunneling.model.TimeoutConfig? = builder.timeoutConfig
    /**
     * The Amazon Resource Name (ARN) of a tunnel.
     */
    public val tunnelArn: kotlin.String? = builder.tunnelArn
    /**
     * A unique alpha-numeric ID that identifies a tunnel.
     */
    public val tunnelId: kotlin.String? = builder.tunnelId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotsecuretunneling.model.Tunnel = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Tunnel(")
        append("createdAt=$createdAt,")
        append("description=$description,")
        append("destinationConfig=$destinationConfig,")
        append("destinationConnectionState=$destinationConnectionState,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("sourceConnectionState=$sourceConnectionState,")
        append("status=$status,")
        append("tags=$tags,")
        append("timeoutConfig=$timeoutConfig,")
        append("tunnelArn=$tunnelArn,")
        append("tunnelId=$tunnelId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (destinationConfig?.hashCode() ?: 0)
        result = 31 * result + (destinationConnectionState?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (sourceConnectionState?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (timeoutConfig?.hashCode() ?: 0)
        result = 31 * result + (tunnelArn?.hashCode() ?: 0)
        result = 31 * result + (tunnelId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Tunnel

        if (createdAt != other.createdAt) return false
        if (description != other.description) return false
        if (destinationConfig != other.destinationConfig) return false
        if (destinationConnectionState != other.destinationConnectionState) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (sourceConnectionState != other.sourceConnectionState) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (timeoutConfig != other.timeoutConfig) return false
        if (tunnelArn != other.tunnelArn) return false
        if (tunnelId != other.tunnelId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotsecuretunneling.model.Tunnel = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The time when the tunnel was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A description of the tunnel.
         */
        public var description: kotlin.String? = null
        /**
         * The destination configuration that specifies the thing name of the destination device and a service name that the local proxy uses to connect to the destination application.
         */
        public var destinationConfig: aws.sdk.kotlin.services.iotsecuretunneling.model.DestinationConfig? = null
        /**
         * The connection state of the destination application.
         */
        public var destinationConnectionState: aws.sdk.kotlin.services.iotsecuretunneling.model.ConnectionState? = null
        /**
         * The last time the tunnel was updated.
         */
        public var lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The connection state of the source application.
         */
        public var sourceConnectionState: aws.sdk.kotlin.services.iotsecuretunneling.model.ConnectionState? = null
        /**
         * The status of a tunnel. Valid values are: Open and Closed.
         */
        public var status: aws.sdk.kotlin.services.iotsecuretunneling.model.TunnelStatus? = null
        /**
         * A list of tag metadata associated with the secure tunnel.
         */
        public var tags: List<Tag>? = null
        /**
         * Timeout configuration for the tunnel.
         */
        public var timeoutConfig: aws.sdk.kotlin.services.iotsecuretunneling.model.TimeoutConfig? = null
        /**
         * The Amazon Resource Name (ARN) of a tunnel.
         */
        public var tunnelArn: kotlin.String? = null
        /**
         * A unique alpha-numeric ID that identifies a tunnel.
         */
        public var tunnelId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotsecuretunneling.model.Tunnel) : this() {
            this.createdAt = x.createdAt
            this.description = x.description
            this.destinationConfig = x.destinationConfig
            this.destinationConnectionState = x.destinationConnectionState
            this.lastUpdatedAt = x.lastUpdatedAt
            this.sourceConnectionState = x.sourceConnectionState
            this.status = x.status
            this.tags = x.tags
            this.timeoutConfig = x.timeoutConfig
            this.tunnelArn = x.tunnelArn
            this.tunnelId = x.tunnelId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotsecuretunneling.model.Tunnel = Tunnel(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotsecuretunneling.model.DestinationConfig] inside the given [block]
         */
        public fun destinationConfig(block: aws.sdk.kotlin.services.iotsecuretunneling.model.DestinationConfig.Builder.() -> kotlin.Unit) {
            this.destinationConfig = aws.sdk.kotlin.services.iotsecuretunneling.model.DestinationConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iotsecuretunneling.model.ConnectionState] inside the given [block]
         */
        public fun destinationConnectionState(block: aws.sdk.kotlin.services.iotsecuretunneling.model.ConnectionState.Builder.() -> kotlin.Unit) {
            this.destinationConnectionState = aws.sdk.kotlin.services.iotsecuretunneling.model.ConnectionState.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iotsecuretunneling.model.ConnectionState] inside the given [block]
         */
        public fun sourceConnectionState(block: aws.sdk.kotlin.services.iotsecuretunneling.model.ConnectionState.Builder.() -> kotlin.Unit) {
            this.sourceConnectionState = aws.sdk.kotlin.services.iotsecuretunneling.model.ConnectionState.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iotsecuretunneling.model.TimeoutConfig] inside the given [block]
         */
        public fun timeoutConfig(block: aws.sdk.kotlin.services.iotsecuretunneling.model.TimeoutConfig.Builder.() -> kotlin.Unit) {
            this.timeoutConfig = aws.sdk.kotlin.services.iotsecuretunneling.model.TimeoutConfig.invoke(block)
        }
    }
}
