// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsecuretunneling.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iotsecuretunneling.model.DescribeTunnelResponse
import aws.sdk.kotlin.services.iotsecuretunneling.model.IoTSecureTunnelingException
import aws.sdk.kotlin.services.iotsecuretunneling.model.Tunnel
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeTunnelOperationDeserializer: HttpDeserialize<DescribeTunnelResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeTunnelResponse {
        if (!response.status.isSuccess()) {
            throwDescribeTunnelError(context, response)
        }
        val builder = DescribeTunnelResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeTunnelOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeTunnelError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IoTSecureTunnelingException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IoTSecureTunnelingException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeTunnelOperationBody(builder: DescribeTunnelResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val TUNNEL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("tunnel"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(TUNNEL_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                TUNNEL_DESCRIPTOR.index -> builder.tunnel = deserializeTunnelDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
