// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotthingsgraph

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.runtime.protocol.json.AwsJsonProtocol
import aws.sdk.kotlin.services.iotthingsgraph.model.*
import aws.sdk.kotlin.services.iotthingsgraph.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "IoTThingsGraph"
const val ServiceApiVersion: String = "2018-09-06"
const val SdkVersion: String = "0.16.6-beta"

internal class DefaultIoTThingsGraphClient(override val config: IoTThingsGraphClient.Config) : IoTThingsGraphClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Associates a device with a concrete thing that is in the user's registry.
     *
     * A thing can be associated with only one device at a time. If you associate a thing with a new device id, its previous association will be removed.
     */
    override suspend fun associateEntityToThing(input: AssociateEntityToThingRequest): AssociateEntityToThingResponse {
        val op = SdkHttpOperation.build<AssociateEntityToThingRequest, AssociateEntityToThingResponse> {
            serializer = AssociateEntityToThingOperationSerializer()
            deserializer = AssociateEntityToThingOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateEntityToThing"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotthingsgraph"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a workflow template. Workflows can be created only in the user's namespace. (The public namespace contains only entities.) The workflow can contain only entities in the specified namespace. The workflow is validated against the entities in the latest version of the user's namespace unless another namespace version is specified in the request.
     */
    override suspend fun createFlowTemplate(input: CreateFlowTemplateRequest): CreateFlowTemplateResponse {
        val op = SdkHttpOperation.build<CreateFlowTemplateRequest, CreateFlowTemplateResponse> {
            serializer = CreateFlowTemplateOperationSerializer()
            deserializer = CreateFlowTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateFlowTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotthingsgraph"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a system instance.
     *
     * This action validates the system instance, prepares the deployment-related resources. For Greengrass deployments, it updates the Greengrass group that is specified by the `greengrassGroupName` parameter. It also adds a file to the S3 bucket specified by the `s3BucketName` parameter. You need to call `DeploySystemInstance` after running this action.
     *
     * For Greengrass deployments, since this action modifies and adds resources to a Greengrass group and an S3 bucket on the caller's behalf, the calling identity must have write permissions to both the specified Greengrass group and S3 bucket. Otherwise, the call will fail with an authorization error.
     *
     * For cloud deployments, this action requires a `flowActionsRoleArn` value. This is an IAM role that has permissions to access AWS services, such as AWS Lambda and AWS IoT, that the flow uses when it executes.
     *
     * If the definition document doesn't specify a version of the user's namespace, the latest version will be used by default.
     */
    override suspend fun createSystemInstance(input: CreateSystemInstanceRequest): CreateSystemInstanceResponse {
        val op = SdkHttpOperation.build<CreateSystemInstanceRequest, CreateSystemInstanceResponse> {
            serializer = CreateSystemInstanceOperationSerializer()
            deserializer = CreateSystemInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateSystemInstance"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotthingsgraph"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a system. The system is validated against the entities in the latest version of the user's namespace unless another namespace version is specified in the request.
     */
    override suspend fun createSystemTemplate(input: CreateSystemTemplateRequest): CreateSystemTemplateResponse {
        val op = SdkHttpOperation.build<CreateSystemTemplateRequest, CreateSystemTemplateResponse> {
            serializer = CreateSystemTemplateOperationSerializer()
            deserializer = CreateSystemTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateSystemTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotthingsgraph"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a workflow. Any new system or deployment that contains this workflow will fail to update or deploy. Existing deployments that contain the workflow will continue to run (since they use a snapshot of the workflow taken at the time of deployment).
     */
    override suspend fun deleteFlowTemplate(input: DeleteFlowTemplateRequest): DeleteFlowTemplateResponse {
        val op = SdkHttpOperation.build<DeleteFlowTemplateRequest, DeleteFlowTemplateResponse> {
            serializer = DeleteFlowTemplateOperationSerializer()
            deserializer = DeleteFlowTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteFlowTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotthingsgraph"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified namespace. This action deletes all of the entities in the namespace. Delete the systems and flows that use entities in the namespace before performing this action.
     */
    override suspend fun deleteNamespace(input: DeleteNamespaceRequest): DeleteNamespaceResponse {
        val op = SdkHttpOperation.build<DeleteNamespaceRequest, DeleteNamespaceResponse> {
            serializer = DeleteNamespaceOperationSerializer()
            deserializer = DeleteNamespaceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteNamespace"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotthingsgraph"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a system instance. Only system instances that have never been deployed, or that have been undeployed can be deleted.
     *
     * Users can create a new system instance that has the same ID as a deleted system instance.
     */
    override suspend fun deleteSystemInstance(input: DeleteSystemInstanceRequest): DeleteSystemInstanceResponse {
        val op = SdkHttpOperation.build<DeleteSystemInstanceRequest, DeleteSystemInstanceResponse> {
            serializer = DeleteSystemInstanceOperationSerializer()
            deserializer = DeleteSystemInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteSystemInstance"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotthingsgraph"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a system. New deployments can't contain the system after its deletion. Existing deployments that contain the system will continue to work because they use a snapshot of the system that is taken when it is deployed.
     */
    override suspend fun deleteSystemTemplate(input: DeleteSystemTemplateRequest): DeleteSystemTemplateResponse {
        val op = SdkHttpOperation.build<DeleteSystemTemplateRequest, DeleteSystemTemplateResponse> {
            serializer = DeleteSystemTemplateOperationSerializer()
            deserializer = DeleteSystemTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteSystemTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotthingsgraph"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * **Greengrass and Cloud Deployments**
     *
     * Deploys the system instance to the target specified in `CreateSystemInstance`.
     *
     * **Greengrass Deployments**
     *
     * If the system or any workflows and entities have been updated before this action is called, then the deployment will create a new Amazon Simple Storage Service resource file and then deploy it.
     *
     * Since this action creates a Greengrass deployment on the caller's behalf, the calling identity must have write permissions to the specified Greengrass group. Otherwise, the call will fail with an authorization error.
     *
     * For information about the artifacts that get added to your Greengrass core device when you use this API, see [AWS IoT Things Graph and AWS IoT Greengrass](https://docs.aws.amazon.com/thingsgraph/latest/ug/iot-tg-greengrass.html).
     */
    override suspend fun deploySystemInstance(input: DeploySystemInstanceRequest): DeploySystemInstanceResponse {
        val op = SdkHttpOperation.build<DeploySystemInstanceRequest, DeploySystemInstanceResponse> {
            serializer = DeploySystemInstanceOperationSerializer()
            deserializer = DeploySystemInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeploySystemInstance"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotthingsgraph"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deprecates the specified workflow. This action marks the workflow for deletion. Deprecated flows can't be deployed, but existing deployments will continue to run.
     */
    override suspend fun deprecateFlowTemplate(input: DeprecateFlowTemplateRequest): DeprecateFlowTemplateResponse {
        val op = SdkHttpOperation.build<DeprecateFlowTemplateRequest, DeprecateFlowTemplateResponse> {
            serializer = DeprecateFlowTemplateOperationSerializer()
            deserializer = DeprecateFlowTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeprecateFlowTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotthingsgraph"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deprecates the specified system.
     */
    override suspend fun deprecateSystemTemplate(input: DeprecateSystemTemplateRequest): DeprecateSystemTemplateResponse {
        val op = SdkHttpOperation.build<DeprecateSystemTemplateRequest, DeprecateSystemTemplateResponse> {
            serializer = DeprecateSystemTemplateOperationSerializer()
            deserializer = DeprecateSystemTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeprecateSystemTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotthingsgraph"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the latest version of the user's namespace and the public version that it is tracking.
     */
    override suspend fun describeNamespace(input: DescribeNamespaceRequest): DescribeNamespaceResponse {
        val op = SdkHttpOperation.build<DescribeNamespaceRequest, DescribeNamespaceResponse> {
            serializer = DescribeNamespaceOperationSerializer()
            deserializer = DescribeNamespaceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeNamespace"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotthingsgraph"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Dissociates a device entity from a concrete thing. The action takes only the type of the entity that you need to dissociate because only one entity of a particular type can be associated with a thing.
     */
    override suspend fun dissociateEntityFromThing(input: DissociateEntityFromThingRequest): DissociateEntityFromThingResponse {
        val op = SdkHttpOperation.build<DissociateEntityFromThingRequest, DissociateEntityFromThingResponse> {
            serializer = DissociateEntityFromThingOperationSerializer()
            deserializer = DissociateEntityFromThingOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DissociateEntityFromThing"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotthingsgraph"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets definitions of the specified entities. Uses the latest version of the user's namespace by default. This API returns the following TDM entities.
     * + Properties
     * + States
     * + Events
     * + Actions
     * + Capabilities
     * + Mappings
     * + Devices
     * + Device Models
     * + Services
     *
     * This action doesn't return definitions for systems, flows, and deployments.
     */
    override suspend fun getEntities(input: GetEntitiesRequest): GetEntitiesResponse {
        val op = SdkHttpOperation.build<GetEntitiesRequest, GetEntitiesResponse> {
            serializer = GetEntitiesOperationSerializer()
            deserializer = GetEntitiesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetEntities"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotthingsgraph"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the latest version of the `DefinitionDocument` and `FlowTemplateSummary` for the specified workflow.
     */
    override suspend fun getFlowTemplate(input: GetFlowTemplateRequest): GetFlowTemplateResponse {
        val op = SdkHttpOperation.build<GetFlowTemplateRequest, GetFlowTemplateResponse> {
            serializer = GetFlowTemplateOperationSerializer()
            deserializer = GetFlowTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetFlowTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotthingsgraph"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets revisions of the specified workflow. Only the last 100 revisions are stored. If the workflow has been deprecated, this action will return revisions that occurred before the deprecation. This action won't work for workflows that have been deleted.
     */
    override suspend fun getFlowTemplateRevisions(input: GetFlowTemplateRevisionsRequest): GetFlowTemplateRevisionsResponse {
        val op = SdkHttpOperation.build<GetFlowTemplateRevisionsRequest, GetFlowTemplateRevisionsResponse> {
            serializer = GetFlowTemplateRevisionsOperationSerializer()
            deserializer = GetFlowTemplateRevisionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetFlowTemplateRevisions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotthingsgraph"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the status of a namespace deletion task.
     */
    override suspend fun getNamespaceDeletionStatus(input: GetNamespaceDeletionStatusRequest): GetNamespaceDeletionStatusResponse {
        val op = SdkHttpOperation.build<GetNamespaceDeletionStatusRequest, GetNamespaceDeletionStatusResponse> {
            serializer = GetNamespaceDeletionStatusOperationSerializer()
            deserializer = GetNamespaceDeletionStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetNamespaceDeletionStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotthingsgraph"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a system instance.
     */
    override suspend fun getSystemInstance(input: GetSystemInstanceRequest): GetSystemInstanceResponse {
        val op = SdkHttpOperation.build<GetSystemInstanceRequest, GetSystemInstanceResponse> {
            serializer = GetSystemInstanceOperationSerializer()
            deserializer = GetSystemInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSystemInstance"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotthingsgraph"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a system.
     */
    override suspend fun getSystemTemplate(input: GetSystemTemplateRequest): GetSystemTemplateResponse {
        val op = SdkHttpOperation.build<GetSystemTemplateRequest, GetSystemTemplateResponse> {
            serializer = GetSystemTemplateOperationSerializer()
            deserializer = GetSystemTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSystemTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotthingsgraph"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets revisions made to the specified system template. Only the previous 100 revisions are stored. If the system has been deprecated, this action will return the revisions that occurred before its deprecation. This action won't work with systems that have been deleted.
     */
    override suspend fun getSystemTemplateRevisions(input: GetSystemTemplateRevisionsRequest): GetSystemTemplateRevisionsResponse {
        val op = SdkHttpOperation.build<GetSystemTemplateRevisionsRequest, GetSystemTemplateRevisionsResponse> {
            serializer = GetSystemTemplateRevisionsOperationSerializer()
            deserializer = GetSystemTemplateRevisionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSystemTemplateRevisions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotthingsgraph"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the status of the specified upload.
     */
    override suspend fun getUploadStatus(input: GetUploadStatusRequest): GetUploadStatusResponse {
        val op = SdkHttpOperation.build<GetUploadStatusRequest, GetUploadStatusResponse> {
            serializer = GetUploadStatusOperationSerializer()
            deserializer = GetUploadStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetUploadStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotthingsgraph"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of objects that contain information about events in a flow execution.
     */
    override suspend fun listFlowExecutionMessages(input: ListFlowExecutionMessagesRequest): ListFlowExecutionMessagesResponse {
        val op = SdkHttpOperation.build<ListFlowExecutionMessagesRequest, ListFlowExecutionMessagesResponse> {
            serializer = ListFlowExecutionMessagesOperationSerializer()
            deserializer = ListFlowExecutionMessagesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListFlowExecutionMessages"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotthingsgraph"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all tags on an AWS IoT Things Graph resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotthingsgraph"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Searches for entities of the specified type. You can search for entities in your namespace and the public namespace that you're tracking.
     */
    override suspend fun searchEntities(input: SearchEntitiesRequest): SearchEntitiesResponse {
        val op = SdkHttpOperation.build<SearchEntitiesRequest, SearchEntitiesResponse> {
            serializer = SearchEntitiesOperationSerializer()
            deserializer = SearchEntitiesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SearchEntities"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotthingsgraph"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Searches for AWS IoT Things Graph workflow execution instances.
     */
    override suspend fun searchFlowExecutions(input: SearchFlowExecutionsRequest): SearchFlowExecutionsResponse {
        val op = SdkHttpOperation.build<SearchFlowExecutionsRequest, SearchFlowExecutionsResponse> {
            serializer = SearchFlowExecutionsOperationSerializer()
            deserializer = SearchFlowExecutionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SearchFlowExecutions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotthingsgraph"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Searches for summary information about workflows.
     */
    override suspend fun searchFlowTemplates(input: SearchFlowTemplatesRequest): SearchFlowTemplatesResponse {
        val op = SdkHttpOperation.build<SearchFlowTemplatesRequest, SearchFlowTemplatesResponse> {
            serializer = SearchFlowTemplatesOperationSerializer()
            deserializer = SearchFlowTemplatesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SearchFlowTemplates"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotthingsgraph"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Searches for system instances in the user's account.
     */
    override suspend fun searchSystemInstances(input: SearchSystemInstancesRequest): SearchSystemInstancesResponse {
        val op = SdkHttpOperation.build<SearchSystemInstancesRequest, SearchSystemInstancesResponse> {
            serializer = SearchSystemInstancesOperationSerializer()
            deserializer = SearchSystemInstancesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SearchSystemInstances"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotthingsgraph"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Searches for summary information about systems in the user's account. You can filter by the ID of a workflow to return only systems that use the specified workflow.
     */
    override suspend fun searchSystemTemplates(input: SearchSystemTemplatesRequest): SearchSystemTemplatesResponse {
        val op = SdkHttpOperation.build<SearchSystemTemplatesRequest, SearchSystemTemplatesResponse> {
            serializer = SearchSystemTemplatesOperationSerializer()
            deserializer = SearchSystemTemplatesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SearchSystemTemplates"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotthingsgraph"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Searches for things associated with the specified entity. You can search by both device and device model.
     *
     * For example, if two different devices, camera1 and camera2, implement the camera device model, the user can associate thing1 to camera1 and thing2 to camera2. `SearchThings(camera2)` will return only thing2, but `SearchThings(camera)` will return both thing1 and thing2.
     *
     * This action searches for exact matches and doesn't perform partial text matching.
     */
    override suspend fun searchThings(input: SearchThingsRequest): SearchThingsResponse {
        val op = SdkHttpOperation.build<SearchThingsRequest, SearchThingsResponse> {
            serializer = SearchThingsOperationSerializer()
            deserializer = SearchThingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SearchThings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotthingsgraph"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a tag for the specified resource.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotthingsgraph"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes a system instance from its target (Cloud or Greengrass).
     */
    override suspend fun undeploySystemInstance(input: UndeploySystemInstanceRequest): UndeploySystemInstanceResponse {
        val op = SdkHttpOperation.build<UndeploySystemInstanceRequest, UndeploySystemInstanceResponse> {
            serializer = UndeploySystemInstanceOperationSerializer()
            deserializer = UndeploySystemInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UndeploySystemInstance"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotthingsgraph"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes a tag from the specified resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotthingsgraph"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified workflow. All deployed systems and system instances that use the workflow will see the changes in the flow when it is redeployed. If you don't want this behavior, copy the workflow (creating a new workflow with a different ID), and update the copy. The workflow can contain only entities in the specified namespace.
     */
    override suspend fun updateFlowTemplate(input: UpdateFlowTemplateRequest): UpdateFlowTemplateResponse {
        val op = SdkHttpOperation.build<UpdateFlowTemplateRequest, UpdateFlowTemplateResponse> {
            serializer = UpdateFlowTemplateOperationSerializer()
            deserializer = UpdateFlowTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateFlowTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotthingsgraph"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified system. You don't need to run this action after updating a workflow. Any deployment that uses the system will see the changes in the system when it is redeployed.
     */
    override suspend fun updateSystemTemplate(input: UpdateSystemTemplateRequest): UpdateSystemTemplateResponse {
        val op = SdkHttpOperation.build<UpdateSystemTemplateRequest, UpdateSystemTemplateResponse> {
            serializer = UpdateSystemTemplateOperationSerializer()
            deserializer = UpdateSystemTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateSystemTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotthingsgraph"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Asynchronously uploads one or more entity definitions to the user's namespace. The `document` parameter is required if `syncWithPublicNamespace` and `deleteExistingEntites` are false. If the `syncWithPublicNamespace` parameter is set to `true`, the user's namespace will synchronize with the latest version of the public namespace. If `deprecateExistingEntities` is set to true, all entities in the latest version will be deleted before the new `DefinitionDocument` is uploaded.
     *
     * When a user uploads entity definitions for the first time, the service creates a new namespace for the user. The new namespace tracks the public namespace. Currently users can have only one namespace. The namespace version increments whenever a user uploads entity definitions that are backwards-incompatible and whenever a user sets the `syncWithPublicNamespace` parameter or the `deprecateExistingEntities` parameter to `true`.
     *
     * The IDs for all of the entities should be in URN format. Each entity must be in the user's namespace. Users can't create entities in the public namespace, but entity definitions can refer to entities in the public namespace.
     *
     * Valid entities are `Device`, `DeviceModel`, `Service`, `Capability`, `State`, `Action`, `Event`, `Property`, `Mapping`, `Enum`.
     */
    override suspend fun uploadEntityDefinitions(input: UploadEntityDefinitionsRequest): UploadEntityDefinitionsResponse {
        val op = SdkHttpOperation.build<UploadEntityDefinitionsRequest, UploadEntityDefinitionsResponse> {
            serializer = UploadEntityDefinitionsOperationSerializer()
            deserializer = UploadEntityDefinitionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UploadEntityDefinitions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IotThingsGraphFrontEndService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotthingsgraph"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "iotthingsgraph")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
