// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotthingsgraph

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.iotthingsgraph.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.iotthingsgraph.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * # AWS IoT Things Graph
 * AWS IoT Things Graph provides an integrated set of tools that enable developers to connect devices and services that use different standards, such as units of measure and communication protocols. AWS IoT Things Graph makes it possible to build IoT applications with little to no code by connecting devices and services and defining how they interact at an abstract level.
 *
 * For more information about how AWS IoT Things Graph works, see the [User Guide](https://docs.aws.amazon.com/thingsgraph/latest/ug/iot-tg-whatis.html).
 */
interface IoTThingsGraphClient : SdkClient {

    override val serviceName: String
        get() = "IoTThingsGraph"
    /**
     * IoTThingsGraphClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): IoTThingsGraphClient {
            val config = Config.Builder().apply(block).build()
            return DefaultIoTThingsGraphClient(config)
        }

        operator fun invoke(config: Config): IoTThingsGraphClient = DefaultIoTThingsGraphClient(config)

        /**
         * Construct a [IoTThingsGraphClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): IoTThingsGraphClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultIoTThingsGraphClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Associates a device with a concrete thing that is in the user's registry.
     *
     * A thing can be associated with only one device at a time. If you associate a thing with a new device id, its previous association will be removed.
     */
    suspend fun associateEntityToThing(input: AssociateEntityToThingRequest): AssociateEntityToThingResponse

    /**
     * Associates a device with a concrete thing that is in the user's registry.
     *
     * A thing can be associated with only one device at a time. If you associate a thing with a new device id, its previous association will be removed.
     */
    suspend fun associateEntityToThing(block: AssociateEntityToThingRequest.Builder.() -> Unit) = associateEntityToThing(AssociateEntityToThingRequest.Builder().apply(block).build())

    /**
     * Creates a workflow template. Workflows can be created only in the user's namespace. (The public namespace contains only entities.) The workflow can contain only entities in the specified namespace. The workflow is validated against the entities in the latest version of the user's namespace unless another namespace version is specified in the request.
     */
    suspend fun createFlowTemplate(input: CreateFlowTemplateRequest): CreateFlowTemplateResponse

    /**
     * Creates a workflow template. Workflows can be created only in the user's namespace. (The public namespace contains only entities.) The workflow can contain only entities in the specified namespace. The workflow is validated against the entities in the latest version of the user's namespace unless another namespace version is specified in the request.
     */
    suspend fun createFlowTemplate(block: CreateFlowTemplateRequest.Builder.() -> Unit) = createFlowTemplate(CreateFlowTemplateRequest.Builder().apply(block).build())

    /**
     * Creates a system instance.
     *
     * This action validates the system instance, prepares the deployment-related resources. For Greengrass deployments, it updates the Greengrass group that is specified by the `greengrassGroupName` parameter. It also adds a file to the S3 bucket specified by the `s3BucketName` parameter. You need to call `DeploySystemInstance` after running this action.
     *
     * For Greengrass deployments, since this action modifies and adds resources to a Greengrass group and an S3 bucket on the caller's behalf, the calling identity must have write permissions to both the specified Greengrass group and S3 bucket. Otherwise, the call will fail with an authorization error.
     *
     * For cloud deployments, this action requires a `flowActionsRoleArn` value. This is an IAM role that has permissions to access AWS services, such as AWS Lambda and AWS IoT, that the flow uses when it executes.
     *
     * If the definition document doesn't specify a version of the user's namespace, the latest version will be used by default.
     */
    suspend fun createSystemInstance(input: CreateSystemInstanceRequest): CreateSystemInstanceResponse

    /**
     * Creates a system instance.
     *
     * This action validates the system instance, prepares the deployment-related resources. For Greengrass deployments, it updates the Greengrass group that is specified by the `greengrassGroupName` parameter. It also adds a file to the S3 bucket specified by the `s3BucketName` parameter. You need to call `DeploySystemInstance` after running this action.
     *
     * For Greengrass deployments, since this action modifies and adds resources to a Greengrass group and an S3 bucket on the caller's behalf, the calling identity must have write permissions to both the specified Greengrass group and S3 bucket. Otherwise, the call will fail with an authorization error.
     *
     * For cloud deployments, this action requires a `flowActionsRoleArn` value. This is an IAM role that has permissions to access AWS services, such as AWS Lambda and AWS IoT, that the flow uses when it executes.
     *
     * If the definition document doesn't specify a version of the user's namespace, the latest version will be used by default.
     */
    suspend fun createSystemInstance(block: CreateSystemInstanceRequest.Builder.() -> Unit) = createSystemInstance(CreateSystemInstanceRequest.Builder().apply(block).build())

    /**
     * Creates a system. The system is validated against the entities in the latest version of the user's namespace unless another namespace version is specified in the request.
     */
    suspend fun createSystemTemplate(input: CreateSystemTemplateRequest): CreateSystemTemplateResponse

    /**
     * Creates a system. The system is validated against the entities in the latest version of the user's namespace unless another namespace version is specified in the request.
     */
    suspend fun createSystemTemplate(block: CreateSystemTemplateRequest.Builder.() -> Unit) = createSystemTemplate(CreateSystemTemplateRequest.Builder().apply(block).build())

    /**
     * Deletes a workflow. Any new system or deployment that contains this workflow will fail to update or deploy. Existing deployments that contain the workflow will continue to run (since they use a snapshot of the workflow taken at the time of deployment).
     */
    suspend fun deleteFlowTemplate(input: DeleteFlowTemplateRequest): DeleteFlowTemplateResponse

    /**
     * Deletes a workflow. Any new system or deployment that contains this workflow will fail to update or deploy. Existing deployments that contain the workflow will continue to run (since they use a snapshot of the workflow taken at the time of deployment).
     */
    suspend fun deleteFlowTemplate(block: DeleteFlowTemplateRequest.Builder.() -> Unit) = deleteFlowTemplate(DeleteFlowTemplateRequest.Builder().apply(block).build())

    /**
     * Deletes the specified namespace. This action deletes all of the entities in the namespace. Delete the systems and flows that use entities in the namespace before performing this action.
     */
    suspend fun deleteNamespace(input: DeleteNamespaceRequest = DeleteNamespaceRequest {}): DeleteNamespaceResponse

    /**
     * Deletes the specified namespace. This action deletes all of the entities in the namespace. Delete the systems and flows that use entities in the namespace before performing this action.
     */
    suspend fun deleteNamespace(block: DeleteNamespaceRequest.Builder.() -> Unit) = deleteNamespace(DeleteNamespaceRequest.Builder().apply(block).build())

    /**
     * Deletes a system instance. Only system instances that have never been deployed, or that have been undeployed can be deleted.
     *
     * Users can create a new system instance that has the same ID as a deleted system instance.
     */
    suspend fun deleteSystemInstance(input: DeleteSystemInstanceRequest = DeleteSystemInstanceRequest {}): DeleteSystemInstanceResponse

    /**
     * Deletes a system instance. Only system instances that have never been deployed, or that have been undeployed can be deleted.
     *
     * Users can create a new system instance that has the same ID as a deleted system instance.
     */
    suspend fun deleteSystemInstance(block: DeleteSystemInstanceRequest.Builder.() -> Unit) = deleteSystemInstance(DeleteSystemInstanceRequest.Builder().apply(block).build())

    /**
     * Deletes a system. New deployments can't contain the system after its deletion. Existing deployments that contain the system will continue to work because they use a snapshot of the system that is taken when it is deployed.
     */
    suspend fun deleteSystemTemplate(input: DeleteSystemTemplateRequest): DeleteSystemTemplateResponse

    /**
     * Deletes a system. New deployments can't contain the system after its deletion. Existing deployments that contain the system will continue to work because they use a snapshot of the system that is taken when it is deployed.
     */
    suspend fun deleteSystemTemplate(block: DeleteSystemTemplateRequest.Builder.() -> Unit) = deleteSystemTemplate(DeleteSystemTemplateRequest.Builder().apply(block).build())

    /**
     * **Greengrass and Cloud Deployments**
     *
     * Deploys the system instance to the target specified in `CreateSystemInstance`.
     *
     * **Greengrass Deployments**
     *
     * If the system or any workflows and entities have been updated before this action is called, then the deployment will create a new Amazon Simple Storage Service resource file and then deploy it.
     *
     * Since this action creates a Greengrass deployment on the caller's behalf, the calling identity must have write permissions to the specified Greengrass group. Otherwise, the call will fail with an authorization error.
     *
     * For information about the artifacts that get added to your Greengrass core device when you use this API, see [AWS IoT Things Graph and AWS IoT Greengrass](https://docs.aws.amazon.com/thingsgraph/latest/ug/iot-tg-greengrass.html).
     */
    suspend fun deploySystemInstance(input: DeploySystemInstanceRequest = DeploySystemInstanceRequest {}): DeploySystemInstanceResponse

    /**
     * **Greengrass and Cloud Deployments**
     *
     * Deploys the system instance to the target specified in `CreateSystemInstance`.
     *
     * **Greengrass Deployments**
     *
     * If the system or any workflows and entities have been updated before this action is called, then the deployment will create a new Amazon Simple Storage Service resource file and then deploy it.
     *
     * Since this action creates a Greengrass deployment on the caller's behalf, the calling identity must have write permissions to the specified Greengrass group. Otherwise, the call will fail with an authorization error.
     *
     * For information about the artifacts that get added to your Greengrass core device when you use this API, see [AWS IoT Things Graph and AWS IoT Greengrass](https://docs.aws.amazon.com/thingsgraph/latest/ug/iot-tg-greengrass.html).
     */
    suspend fun deploySystemInstance(block: DeploySystemInstanceRequest.Builder.() -> Unit) = deploySystemInstance(DeploySystemInstanceRequest.Builder().apply(block).build())

    /**
     * Deprecates the specified workflow. This action marks the workflow for deletion. Deprecated flows can't be deployed, but existing deployments will continue to run.
     */
    suspend fun deprecateFlowTemplate(input: DeprecateFlowTemplateRequest): DeprecateFlowTemplateResponse

    /**
     * Deprecates the specified workflow. This action marks the workflow for deletion. Deprecated flows can't be deployed, but existing deployments will continue to run.
     */
    suspend fun deprecateFlowTemplate(block: DeprecateFlowTemplateRequest.Builder.() -> Unit) = deprecateFlowTemplate(DeprecateFlowTemplateRequest.Builder().apply(block).build())

    /**
     * Deprecates the specified system.
     */
    suspend fun deprecateSystemTemplate(input: DeprecateSystemTemplateRequest): DeprecateSystemTemplateResponse

    /**
     * Deprecates the specified system.
     */
    suspend fun deprecateSystemTemplate(block: DeprecateSystemTemplateRequest.Builder.() -> Unit) = deprecateSystemTemplate(DeprecateSystemTemplateRequest.Builder().apply(block).build())

    /**
     * Gets the latest version of the user's namespace and the public version that it is tracking.
     */
    suspend fun describeNamespace(input: DescribeNamespaceRequest = DescribeNamespaceRequest {}): DescribeNamespaceResponse

    /**
     * Gets the latest version of the user's namespace and the public version that it is tracking.
     */
    suspend fun describeNamespace(block: DescribeNamespaceRequest.Builder.() -> Unit) = describeNamespace(DescribeNamespaceRequest.Builder().apply(block).build())

    /**
     * Dissociates a device entity from a concrete thing. The action takes only the type of the entity that you need to dissociate because only one entity of a particular type can be associated with a thing.
     */
    suspend fun dissociateEntityFromThing(input: DissociateEntityFromThingRequest): DissociateEntityFromThingResponse

    /**
     * Dissociates a device entity from a concrete thing. The action takes only the type of the entity that you need to dissociate because only one entity of a particular type can be associated with a thing.
     */
    suspend fun dissociateEntityFromThing(block: DissociateEntityFromThingRequest.Builder.() -> Unit) = dissociateEntityFromThing(DissociateEntityFromThingRequest.Builder().apply(block).build())

    /**
     * Gets definitions of the specified entities. Uses the latest version of the user's namespace by default. This API returns the following TDM entities.
     * + Properties
     * + States
     * + Events
     * + Actions
     * + Capabilities
     * + Mappings
     * + Devices
     * + Device Models
     * + Services
     *
     * This action doesn't return definitions for systems, flows, and deployments.
     */
    suspend fun getEntities(input: GetEntitiesRequest): GetEntitiesResponse

    /**
     * Gets definitions of the specified entities. Uses the latest version of the user's namespace by default. This API returns the following TDM entities.
     * + Properties
     * + States
     * + Events
     * + Actions
     * + Capabilities
     * + Mappings
     * + Devices
     * + Device Models
     * + Services
     *
     * This action doesn't return definitions for systems, flows, and deployments.
     */
    suspend fun getEntities(block: GetEntitiesRequest.Builder.() -> Unit) = getEntities(GetEntitiesRequest.Builder().apply(block).build())

    /**
     * Gets the latest version of the `DefinitionDocument` and `FlowTemplateSummary` for the specified workflow.
     */
    suspend fun getFlowTemplate(input: GetFlowTemplateRequest): GetFlowTemplateResponse

    /**
     * Gets the latest version of the `DefinitionDocument` and `FlowTemplateSummary` for the specified workflow.
     */
    suspend fun getFlowTemplate(block: GetFlowTemplateRequest.Builder.() -> Unit) = getFlowTemplate(GetFlowTemplateRequest.Builder().apply(block).build())

    /**
     * Gets revisions of the specified workflow. Only the last 100 revisions are stored. If the workflow has been deprecated, this action will return revisions that occurred before the deprecation. This action won't work for workflows that have been deleted.
     */
    suspend fun getFlowTemplateRevisions(input: GetFlowTemplateRevisionsRequest): GetFlowTemplateRevisionsResponse

    /**
     * Gets revisions of the specified workflow. Only the last 100 revisions are stored. If the workflow has been deprecated, this action will return revisions that occurred before the deprecation. This action won't work for workflows that have been deleted.
     */
    suspend fun getFlowTemplateRevisions(block: GetFlowTemplateRevisionsRequest.Builder.() -> Unit) = getFlowTemplateRevisions(GetFlowTemplateRevisionsRequest.Builder().apply(block).build())

    /**
     * Gets the status of a namespace deletion task.
     */
    suspend fun getNamespaceDeletionStatus(input: GetNamespaceDeletionStatusRequest = GetNamespaceDeletionStatusRequest {}): GetNamespaceDeletionStatusResponse

    /**
     * Gets the status of a namespace deletion task.
     */
    suspend fun getNamespaceDeletionStatus(block: GetNamespaceDeletionStatusRequest.Builder.() -> Unit) = getNamespaceDeletionStatus(GetNamespaceDeletionStatusRequest.Builder().apply(block).build())

    /**
     * Gets a system instance.
     */
    suspend fun getSystemInstance(input: GetSystemInstanceRequest): GetSystemInstanceResponse

    /**
     * Gets a system instance.
     */
    suspend fun getSystemInstance(block: GetSystemInstanceRequest.Builder.() -> Unit) = getSystemInstance(GetSystemInstanceRequest.Builder().apply(block).build())

    /**
     * Gets a system.
     */
    suspend fun getSystemTemplate(input: GetSystemTemplateRequest): GetSystemTemplateResponse

    /**
     * Gets a system.
     */
    suspend fun getSystemTemplate(block: GetSystemTemplateRequest.Builder.() -> Unit) = getSystemTemplate(GetSystemTemplateRequest.Builder().apply(block).build())

    /**
     * Gets revisions made to the specified system template. Only the previous 100 revisions are stored. If the system has been deprecated, this action will return the revisions that occurred before its deprecation. This action won't work with systems that have been deleted.
     */
    suspend fun getSystemTemplateRevisions(input: GetSystemTemplateRevisionsRequest): GetSystemTemplateRevisionsResponse

    /**
     * Gets revisions made to the specified system template. Only the previous 100 revisions are stored. If the system has been deprecated, this action will return the revisions that occurred before its deprecation. This action won't work with systems that have been deleted.
     */
    suspend fun getSystemTemplateRevisions(block: GetSystemTemplateRevisionsRequest.Builder.() -> Unit) = getSystemTemplateRevisions(GetSystemTemplateRevisionsRequest.Builder().apply(block).build())

    /**
     * Gets the status of the specified upload.
     */
    suspend fun getUploadStatus(input: GetUploadStatusRequest): GetUploadStatusResponse

    /**
     * Gets the status of the specified upload.
     */
    suspend fun getUploadStatus(block: GetUploadStatusRequest.Builder.() -> Unit) = getUploadStatus(GetUploadStatusRequest.Builder().apply(block).build())

    /**
     * Returns a list of objects that contain information about events in a flow execution.
     */
    suspend fun listFlowExecutionMessages(input: ListFlowExecutionMessagesRequest): ListFlowExecutionMessagesResponse

    /**
     * Returns a list of objects that contain information about events in a flow execution.
     */
    suspend fun listFlowExecutionMessages(block: ListFlowExecutionMessagesRequest.Builder.() -> Unit) = listFlowExecutionMessages(ListFlowExecutionMessagesRequest.Builder().apply(block).build())

    /**
     * Lists all tags on an AWS IoT Things Graph resource.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists all tags on an AWS IoT Things Graph resource.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

    /**
     * Searches for entities of the specified type. You can search for entities in your namespace and the public namespace that you're tracking.
     */
    suspend fun searchEntities(input: SearchEntitiesRequest): SearchEntitiesResponse

    /**
     * Searches for entities of the specified type. You can search for entities in your namespace and the public namespace that you're tracking.
     */
    suspend fun searchEntities(block: SearchEntitiesRequest.Builder.() -> Unit) = searchEntities(SearchEntitiesRequest.Builder().apply(block).build())

    /**
     * Searches for AWS IoT Things Graph workflow execution instances.
     */
    suspend fun searchFlowExecutions(input: SearchFlowExecutionsRequest): SearchFlowExecutionsResponse

    /**
     * Searches for AWS IoT Things Graph workflow execution instances.
     */
    suspend fun searchFlowExecutions(block: SearchFlowExecutionsRequest.Builder.() -> Unit) = searchFlowExecutions(SearchFlowExecutionsRequest.Builder().apply(block).build())

    /**
     * Searches for summary information about workflows.
     */
    suspend fun searchFlowTemplates(input: SearchFlowTemplatesRequest = SearchFlowTemplatesRequest {}): SearchFlowTemplatesResponse

    /**
     * Searches for summary information about workflows.
     */
    suspend fun searchFlowTemplates(block: SearchFlowTemplatesRequest.Builder.() -> Unit) = searchFlowTemplates(SearchFlowTemplatesRequest.Builder().apply(block).build())

    /**
     * Searches for system instances in the user's account.
     */
    suspend fun searchSystemInstances(input: SearchSystemInstancesRequest = SearchSystemInstancesRequest {}): SearchSystemInstancesResponse

    /**
     * Searches for system instances in the user's account.
     */
    suspend fun searchSystemInstances(block: SearchSystemInstancesRequest.Builder.() -> Unit) = searchSystemInstances(SearchSystemInstancesRequest.Builder().apply(block).build())

    /**
     * Searches for summary information about systems in the user's account. You can filter by the ID of a workflow to return only systems that use the specified workflow.
     */
    suspend fun searchSystemTemplates(input: SearchSystemTemplatesRequest = SearchSystemTemplatesRequest {}): SearchSystemTemplatesResponse

    /**
     * Searches for summary information about systems in the user's account. You can filter by the ID of a workflow to return only systems that use the specified workflow.
     */
    suspend fun searchSystemTemplates(block: SearchSystemTemplatesRequest.Builder.() -> Unit) = searchSystemTemplates(SearchSystemTemplatesRequest.Builder().apply(block).build())

    /**
     * Searches for things associated with the specified entity. You can search by both device and device model.
     *
     * For example, if two different devices, camera1 and camera2, implement the camera device model, the user can associate thing1 to camera1 and thing2 to camera2. `SearchThings(camera2)` will return only thing2, but `SearchThings(camera)` will return both thing1 and thing2.
     *
     * This action searches for exact matches and doesn't perform partial text matching.
     */
    suspend fun searchThings(input: SearchThingsRequest): SearchThingsResponse

    /**
     * Searches for things associated with the specified entity. You can search by both device and device model.
     *
     * For example, if two different devices, camera1 and camera2, implement the camera device model, the user can associate thing1 to camera1 and thing2 to camera2. `SearchThings(camera2)` will return only thing2, but `SearchThings(camera)` will return both thing1 and thing2.
     *
     * This action searches for exact matches and doesn't perform partial text matching.
     */
    suspend fun searchThings(block: SearchThingsRequest.Builder.() -> Unit) = searchThings(SearchThingsRequest.Builder().apply(block).build())

    /**
     * Creates a tag for the specified resource.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Creates a tag for the specified resource.
     */
    suspend fun tagResource(block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

    /**
     * Removes a system instance from its target (Cloud or Greengrass).
     */
    suspend fun undeploySystemInstance(input: UndeploySystemInstanceRequest = UndeploySystemInstanceRequest {}): UndeploySystemInstanceResponse

    /**
     * Removes a system instance from its target (Cloud or Greengrass).
     */
    suspend fun undeploySystemInstance(block: UndeploySystemInstanceRequest.Builder.() -> Unit) = undeploySystemInstance(UndeploySystemInstanceRequest.Builder().apply(block).build())

    /**
     * Removes a tag from the specified resource.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes a tag from the specified resource.
     */
    suspend fun untagResource(block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

    /**
     * Updates the specified workflow. All deployed systems and system instances that use the workflow will see the changes in the flow when it is redeployed. If you don't want this behavior, copy the workflow (creating a new workflow with a different ID), and update the copy. The workflow can contain only entities in the specified namespace.
     */
    suspend fun updateFlowTemplate(input: UpdateFlowTemplateRequest): UpdateFlowTemplateResponse

    /**
     * Updates the specified workflow. All deployed systems and system instances that use the workflow will see the changes in the flow when it is redeployed. If you don't want this behavior, copy the workflow (creating a new workflow with a different ID), and update the copy. The workflow can contain only entities in the specified namespace.
     */
    suspend fun updateFlowTemplate(block: UpdateFlowTemplateRequest.Builder.() -> Unit) = updateFlowTemplate(UpdateFlowTemplateRequest.Builder().apply(block).build())

    /**
     * Updates the specified system. You don't need to run this action after updating a workflow. Any deployment that uses the system will see the changes in the system when it is redeployed.
     */
    suspend fun updateSystemTemplate(input: UpdateSystemTemplateRequest): UpdateSystemTemplateResponse

    /**
     * Updates the specified system. You don't need to run this action after updating a workflow. Any deployment that uses the system will see the changes in the system when it is redeployed.
     */
    suspend fun updateSystemTemplate(block: UpdateSystemTemplateRequest.Builder.() -> Unit) = updateSystemTemplate(UpdateSystemTemplateRequest.Builder().apply(block).build())

    /**
     * Asynchronously uploads one or more entity definitions to the user's namespace. The `document` parameter is required if `syncWithPublicNamespace` and `deleteExistingEntites` are false. If the `syncWithPublicNamespace` parameter is set to `true`, the user's namespace will synchronize with the latest version of the public namespace. If `deprecateExistingEntities` is set to true, all entities in the latest version will be deleted before the new `DefinitionDocument` is uploaded.
     *
     * When a user uploads entity definitions for the first time, the service creates a new namespace for the user. The new namespace tracks the public namespace. Currently users can have only one namespace. The namespace version increments whenever a user uploads entity definitions that are backwards-incompatible and whenever a user sets the `syncWithPublicNamespace` parameter or the `deprecateExistingEntities` parameter to `true`.
     *
     * The IDs for all of the entities should be in URN format. Each entity must be in the user's namespace. Users can't create entities in the public namespace, but entity definitions can refer to entities in the public namespace.
     *
     * Valid entities are `Device`, `DeviceModel`, `Service`, `Capability`, `State`, `Action`, `Event`, `Property`, `Mapping`, `Enum`.
     */
    suspend fun uploadEntityDefinitions(input: UploadEntityDefinitionsRequest = UploadEntityDefinitionsRequest {}): UploadEntityDefinitionsResponse

    /**
     * Asynchronously uploads one or more entity definitions to the user's namespace. The `document` parameter is required if `syncWithPublicNamespace` and `deleteExistingEntites` are false. If the `syncWithPublicNamespace` parameter is set to `true`, the user's namespace will synchronize with the latest version of the public namespace. If `deprecateExistingEntities` is set to true, all entities in the latest version will be deleted before the new `DefinitionDocument` is uploaded.
     *
     * When a user uploads entity definitions for the first time, the service creates a new namespace for the user. The new namespace tracks the public namespace. Currently users can have only one namespace. The namespace version increments whenever a user uploads entity definitions that are backwards-incompatible and whenever a user sets the `syncWithPublicNamespace` parameter or the `deprecateExistingEntities` parameter to `true`.
     *
     * The IDs for all of the entities should be in URN format. Each entity must be in the user's namespace. Users can't create entities in the public namespace, but entity definitions can refer to entities in the public namespace.
     *
     * Valid entities are `Device`, `DeviceModel`, `Service`, `Capability`, `State`, `Action`, `Event`, `Property`, `Mapping`, `Enum`.
     */
    suspend fun uploadEntityDefinitions(block: UploadEntityDefinitionsRequest.Builder.() -> Unit) = uploadEntityDefinitions(UploadEntityDefinitionsRequest.Builder().apply(block).build())
}
