// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotthingsgraph.model



class CreateSystemInstanceRequest private constructor(builder: Builder) {
    /**
     * A document that defines an entity.
     */
    val definition: aws.sdk.kotlin.services.iotthingsgraph.model.DefinitionDocument? = builder.definition
    /**
     * The ARN of the IAM role that AWS IoT Things Graph will assume when it executes the flow. This role must have read and write access to AWS Lambda and AWS IoT and any other AWS services that the flow uses when it executes. This value is required if the value of the `target` parameter is `CLOUD`.
     */
    val flowActionsRoleArn: kotlin.String? = builder.flowActionsRoleArn
    /**
     * The name of the Greengrass group where the system instance will be deployed. This value is required if the value of the `target` parameter is `GREENGRASS`.
     */
    val greengrassGroupName: kotlin.String? = builder.greengrassGroupName
    /**
     * An object that specifies whether cloud metrics are collected in a deployment and, if so, what role is used to collect metrics.
     */
    val metricsConfiguration: aws.sdk.kotlin.services.iotthingsgraph.model.MetricsConfiguration? = builder.metricsConfiguration
    /**
     * The name of the Amazon Simple Storage Service bucket that will be used to store and deploy the system instance's resource file. This value is required if the value of the `target` parameter is `GREENGRASS`.
     */
    val s3BucketName: kotlin.String? = builder.s3BucketName
    /**
     * Metadata, consisting of key-value pairs, that can be used to categorize your system instances.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The target type of the deployment. Valid values are `GREENGRASS` and `CLOUD`.
     */
    val target: aws.sdk.kotlin.services.iotthingsgraph.model.DeploymentTarget? = builder.target

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotthingsgraph.model.CreateSystemInstanceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateSystemInstanceRequest(")
        append("definition=$definition,")
        append("flowActionsRoleArn=$flowActionsRoleArn,")
        append("greengrassGroupName=$greengrassGroupName,")
        append("metricsConfiguration=$metricsConfiguration,")
        append("s3BucketName=$s3BucketName,")
        append("tags=$tags,")
        append("target=$target)")
    }

    override fun hashCode(): kotlin.Int {
        var result = definition?.hashCode() ?: 0
        result = 31 * result + (flowActionsRoleArn?.hashCode() ?: 0)
        result = 31 * result + (greengrassGroupName?.hashCode() ?: 0)
        result = 31 * result + (metricsConfiguration?.hashCode() ?: 0)
        result = 31 * result + (s3BucketName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (target?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateSystemInstanceRequest

        if (definition != other.definition) return false
        if (flowActionsRoleArn != other.flowActionsRoleArn) return false
        if (greengrassGroupName != other.greengrassGroupName) return false
        if (metricsConfiguration != other.metricsConfiguration) return false
        if (s3BucketName != other.s3BucketName) return false
        if (tags != other.tags) return false
        if (target != other.target) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotthingsgraph.model.CreateSystemInstanceRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A document that defines an entity.
         */
        var definition: aws.sdk.kotlin.services.iotthingsgraph.model.DefinitionDocument? = null
        /**
         * The ARN of the IAM role that AWS IoT Things Graph will assume when it executes the flow. This role must have read and write access to AWS Lambda and AWS IoT and any other AWS services that the flow uses when it executes. This value is required if the value of the `target` parameter is `CLOUD`.
         */
        var flowActionsRoleArn: kotlin.String? = null
        /**
         * The name of the Greengrass group where the system instance will be deployed. This value is required if the value of the `target` parameter is `GREENGRASS`.
         */
        var greengrassGroupName: kotlin.String? = null
        /**
         * An object that specifies whether cloud metrics are collected in a deployment and, if so, what role is used to collect metrics.
         */
        var metricsConfiguration: aws.sdk.kotlin.services.iotthingsgraph.model.MetricsConfiguration? = null
        /**
         * The name of the Amazon Simple Storage Service bucket that will be used to store and deploy the system instance's resource file. This value is required if the value of the `target` parameter is `GREENGRASS`.
         */
        var s3BucketName: kotlin.String? = null
        /**
         * Metadata, consisting of key-value pairs, that can be used to categorize your system instances.
         */
        var tags: List<Tag>? = null
        /**
         * The target type of the deployment. Valid values are `GREENGRASS` and `CLOUD`.
         */
        var target: aws.sdk.kotlin.services.iotthingsgraph.model.DeploymentTarget? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotthingsgraph.model.CreateSystemInstanceRequest) : this() {
            this.definition = x.definition
            this.flowActionsRoleArn = x.flowActionsRoleArn
            this.greengrassGroupName = x.greengrassGroupName
            this.metricsConfiguration = x.metricsConfiguration
            this.s3BucketName = x.s3BucketName
            this.tags = x.tags
            this.target = x.target
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotthingsgraph.model.CreateSystemInstanceRequest = CreateSystemInstanceRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotthingsgraph.model.DefinitionDocument] inside the given [block]
         */
        fun definition(block: aws.sdk.kotlin.services.iotthingsgraph.model.DefinitionDocument.Builder.() -> kotlin.Unit) {
            this.definition = aws.sdk.kotlin.services.iotthingsgraph.model.DefinitionDocument.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iotthingsgraph.model.MetricsConfiguration] inside the given [block]
         */
        fun metricsConfiguration(block: aws.sdk.kotlin.services.iotthingsgraph.model.MetricsConfiguration.Builder.() -> kotlin.Unit) {
            this.metricsConfiguration = aws.sdk.kotlin.services.iotthingsgraph.model.MetricsConfiguration.invoke(block)
        }
    }
}
