// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotthingsgraph.model



/**
 * An object that filters an entity search. Multiple filters function as OR criteria in the search. For example a search that includes a `NAMESPACE` and a `REFERENCED_ENTITY_ID` filter searches for entities in the specified namespace that use the entity specified by the value of `REFERENCED_ENTITY_ID`.
 */
class EntityFilter private constructor(builder: Builder) {
    /**
     * The name of the entity search filter field. `REFERENCED_ENTITY_ID` filters on entities that are used by the entity in the result set. For example, you can filter on the ID of a property that is used in a state.
     */
    val name: aws.sdk.kotlin.services.iotthingsgraph.model.EntityFilterName? = builder.name
    /**
     * An array of string values for the search filter field. Multiple values function as AND criteria in the search.
     */
    val value: List<String>? = builder.value

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotthingsgraph.model.EntityFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EntityFilter(")
        append("name=$name,")
        append("value=$value)")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EntityFilter

        if (name != other.name) return false
        if (value != other.value) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotthingsgraph.model.EntityFilter = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the entity search filter field. `REFERENCED_ENTITY_ID` filters on entities that are used by the entity in the result set. For example, you can filter on the ID of a property that is used in a state.
         */
        var name: aws.sdk.kotlin.services.iotthingsgraph.model.EntityFilterName? = null
        /**
         * An array of string values for the search filter field. Multiple values function as AND criteria in the search.
         */
        var value: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotthingsgraph.model.EntityFilter) : this() {
            this.name = x.name
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotthingsgraph.model.EntityFilter = EntityFilter(this)
    }
}
