// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotthingsgraph.model



/**
 * An object that contains a system instance definition and summary information.
 */
class SystemInstanceDescription private constructor(builder: Builder) {
    /**
     * A document that defines an entity.
     */
    val definition: aws.sdk.kotlin.services.iotthingsgraph.model.DefinitionDocument? = builder.definition
    /**
     * The AWS Identity and Access Management (IAM) role that AWS IoT Things Graph assumes during flow execution in a cloud deployment. This role must have read and write permissionss to AWS Lambda and AWS IoT and to any other AWS services that the flow uses.
     */
    val flowActionsRoleArn: kotlin.String? = builder.flowActionsRoleArn
    /**
     * An object that specifies whether cloud metrics are collected in a deployment and, if so, what role is used to collect metrics.
     */
    val metricsConfiguration: aws.sdk.kotlin.services.iotthingsgraph.model.MetricsConfiguration? = builder.metricsConfiguration
    /**
     * The Amazon Simple Storage Service bucket where information about a system instance is stored.
     */
    val s3BucketName: kotlin.String? = builder.s3BucketName
    /**
     * An object that contains summary information about a system instance.
     */
    val summary: aws.sdk.kotlin.services.iotthingsgraph.model.SystemInstanceSummary? = builder.summary
    /**
     * A list of objects that contain all of the IDs and revision numbers of workflows and systems that are used in a system instance.
     */
    val validatedDependencyRevisions: List<DependencyRevision>? = builder.validatedDependencyRevisions
    /**
     * The version of the user's namespace against which the system instance was validated.
     */
    val validatedNamespaceVersion: kotlin.Long? = builder.validatedNamespaceVersion

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotthingsgraph.model.SystemInstanceDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SystemInstanceDescription(")
        append("definition=$definition,")
        append("flowActionsRoleArn=$flowActionsRoleArn,")
        append("metricsConfiguration=$metricsConfiguration,")
        append("s3BucketName=$s3BucketName,")
        append("summary=$summary,")
        append("validatedDependencyRevisions=$validatedDependencyRevisions,")
        append("validatedNamespaceVersion=$validatedNamespaceVersion)")
    }

    override fun hashCode(): kotlin.Int {
        var result = definition?.hashCode() ?: 0
        result = 31 * result + (flowActionsRoleArn?.hashCode() ?: 0)
        result = 31 * result + (metricsConfiguration?.hashCode() ?: 0)
        result = 31 * result + (s3BucketName?.hashCode() ?: 0)
        result = 31 * result + (summary?.hashCode() ?: 0)
        result = 31 * result + (validatedDependencyRevisions?.hashCode() ?: 0)
        result = 31 * result + (validatedNamespaceVersion?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SystemInstanceDescription

        if (definition != other.definition) return false
        if (flowActionsRoleArn != other.flowActionsRoleArn) return false
        if (metricsConfiguration != other.metricsConfiguration) return false
        if (s3BucketName != other.s3BucketName) return false
        if (summary != other.summary) return false
        if (validatedDependencyRevisions != other.validatedDependencyRevisions) return false
        if (validatedNamespaceVersion != other.validatedNamespaceVersion) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotthingsgraph.model.SystemInstanceDescription = Builder(this).apply(block).build()

    class Builder {
        /**
         * A document that defines an entity.
         */
        var definition: aws.sdk.kotlin.services.iotthingsgraph.model.DefinitionDocument? = null
        /**
         * The AWS Identity and Access Management (IAM) role that AWS IoT Things Graph assumes during flow execution in a cloud deployment. This role must have read and write permissionss to AWS Lambda and AWS IoT and to any other AWS services that the flow uses.
         */
        var flowActionsRoleArn: kotlin.String? = null
        /**
         * An object that specifies whether cloud metrics are collected in a deployment and, if so, what role is used to collect metrics.
         */
        var metricsConfiguration: aws.sdk.kotlin.services.iotthingsgraph.model.MetricsConfiguration? = null
        /**
         * The Amazon Simple Storage Service bucket where information about a system instance is stored.
         */
        var s3BucketName: kotlin.String? = null
        /**
         * An object that contains summary information about a system instance.
         */
        var summary: aws.sdk.kotlin.services.iotthingsgraph.model.SystemInstanceSummary? = null
        /**
         * A list of objects that contain all of the IDs and revision numbers of workflows and systems that are used in a system instance.
         */
        var validatedDependencyRevisions: List<DependencyRevision>? = null
        /**
         * The version of the user's namespace against which the system instance was validated.
         */
        var validatedNamespaceVersion: kotlin.Long? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotthingsgraph.model.SystemInstanceDescription) : this() {
            this.definition = x.definition
            this.flowActionsRoleArn = x.flowActionsRoleArn
            this.metricsConfiguration = x.metricsConfiguration
            this.s3BucketName = x.s3BucketName
            this.summary = x.summary
            this.validatedDependencyRevisions = x.validatedDependencyRevisions
            this.validatedNamespaceVersion = x.validatedNamespaceVersion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotthingsgraph.model.SystemInstanceDescription = SystemInstanceDescription(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotthingsgraph.model.DefinitionDocument] inside the given [block]
         */
        fun definition(block: aws.sdk.kotlin.services.iotthingsgraph.model.DefinitionDocument.Builder.() -> kotlin.Unit) {
            this.definition = aws.sdk.kotlin.services.iotthingsgraph.model.DefinitionDocument.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iotthingsgraph.model.MetricsConfiguration] inside the given [block]
         */
        fun metricsConfiguration(block: aws.sdk.kotlin.services.iotthingsgraph.model.MetricsConfiguration.Builder.() -> kotlin.Unit) {
            this.metricsConfiguration = aws.sdk.kotlin.services.iotthingsgraph.model.MetricsConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iotthingsgraph.model.SystemInstanceSummary] inside the given [block]
         */
        fun summary(block: aws.sdk.kotlin.services.iotthingsgraph.model.SystemInstanceSummary.Builder.() -> kotlin.Unit) {
            this.summary = aws.sdk.kotlin.services.iotthingsgraph.model.SystemInstanceSummary.invoke(block)
        }
    }
}
