// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotthingsgraph.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iotthingsgraph.model.DescribeNamespaceResponse
import aws.sdk.kotlin.services.iotthingsgraph.model.IoTThingsGraphException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeNamespaceOperationDeserializer: HttpDeserialize<DescribeNamespaceResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeNamespaceResponse {
        if (!response.status.isSuccess()) {
            throwDescribeNamespaceError(context, response)
        }
        val builder = DescribeNamespaceResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeNamespaceOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeNamespaceError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IoTThingsGraphException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IoTThingsGraphException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeNamespaceOperationBody(builder: DescribeNamespaceResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NAMESPACEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("namespaceArn"))
    val NAMESPACENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("namespaceName"))
    val NAMESPACEVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("namespaceVersion"))
    val TRACKINGNAMESPACENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("trackingNamespaceName"))
    val TRACKINGNAMESPACEVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("trackingNamespaceVersion"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NAMESPACEARN_DESCRIPTOR)
        field(NAMESPACENAME_DESCRIPTOR)
        field(NAMESPACEVERSION_DESCRIPTOR)
        field(TRACKINGNAMESPACENAME_DESCRIPTOR)
        field(TRACKINGNAMESPACEVERSION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NAMESPACEARN_DESCRIPTOR.index -> builder.namespaceArn = deserializeString()
                NAMESPACENAME_DESCRIPTOR.index -> builder.namespaceName = deserializeString()
                NAMESPACEVERSION_DESCRIPTOR.index -> builder.namespaceVersion = deserializeLong()
                TRACKINGNAMESPACENAME_DESCRIPTOR.index -> builder.trackingNamespaceName = deserializeString()
                TRACKINGNAMESPACEVERSION_DESCRIPTOR.index -> builder.trackingNamespaceVersion = deserializeLong()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
