// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iottwinmaker

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.iottwinmaker.endpoints.internal.ResolveEndpointMiddleware
import aws.sdk.kotlin.services.iottwinmaker.endpoints.internal.bindAwsBuiltins
import aws.sdk.kotlin.services.iottwinmaker.model.*
import aws.sdk.kotlin.services.iottwinmaker.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.sdkRequestId
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.tracing.withRootTraceSpan
import aws.smithy.kotlin.runtime.util.putIfAbsent
import kotlin.coroutines.coroutineContext


public const val ServiceId: String = "IoTTwinMaker"
public const val ServiceApiVersion: String = "2021-11-29"
public const val SdkVersion: String = "0.18.0-beta"

internal class DefaultIoTTwinMakerClient(override val config: IoTTwinMakerClient.Config) : IoTTwinMakerClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Sets values for multiple time series properties.
     */
    override suspend fun batchPutPropertyValues(input: BatchPutPropertyValuesRequest): BatchPutPropertyValuesResponse {
        val op = SdkHttpOperation.build<BatchPutPropertyValuesRequest, BatchPutPropertyValuesResponse> {
            serializer = BatchPutPropertyValuesOperationSerializer()
            deserializer = BatchPutPropertyValuesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchPutPropertyValues"
                hostPrefix = "data."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iottwinmaker"
            }
        )
        val rootSpan = config.tracer.createRootSpan("BatchPutPropertyValues-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a component type.
     */
    override suspend fun createComponentType(input: CreateComponentTypeRequest): CreateComponentTypeResponse {
        val op = SdkHttpOperation.build<CreateComponentTypeRequest, CreateComponentTypeResponse> {
            serializer = CreateComponentTypeOperationSerializer()
            deserializer = CreateComponentTypeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateComponentType"
                hostPrefix = "api."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iottwinmaker"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CreateComponentType-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates an entity.
     */
    override suspend fun createEntity(input: CreateEntityRequest): CreateEntityResponse {
        val op = SdkHttpOperation.build<CreateEntityRequest, CreateEntityResponse> {
            serializer = CreateEntityOperationSerializer()
            deserializer = CreateEntityOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateEntity"
                hostPrefix = "api."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iottwinmaker"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CreateEntity-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a scene.
     */
    override suspend fun createScene(input: CreateSceneRequest): CreateSceneResponse {
        val op = SdkHttpOperation.build<CreateSceneRequest, CreateSceneResponse> {
            serializer = CreateSceneOperationSerializer()
            deserializer = CreateSceneOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateScene"
                hostPrefix = "api."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iottwinmaker"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CreateScene-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a workplace.
     */
    override suspend fun createWorkspace(input: CreateWorkspaceRequest): CreateWorkspaceResponse {
        val op = SdkHttpOperation.build<CreateWorkspaceRequest, CreateWorkspaceResponse> {
            serializer = CreateWorkspaceOperationSerializer()
            deserializer = CreateWorkspaceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateWorkspace"
                hostPrefix = "api."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iottwinmaker"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CreateWorkspace-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a component type.
     */
    override suspend fun deleteComponentType(input: DeleteComponentTypeRequest): DeleteComponentTypeResponse {
        val op = SdkHttpOperation.build<DeleteComponentTypeRequest, DeleteComponentTypeResponse> {
            serializer = DeleteComponentTypeOperationSerializer()
            deserializer = DeleteComponentTypeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteComponentType"
                hostPrefix = "api."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iottwinmaker"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DeleteComponentType-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes an entity.
     */
    override suspend fun deleteEntity(input: DeleteEntityRequest): DeleteEntityResponse {
        val op = SdkHttpOperation.build<DeleteEntityRequest, DeleteEntityResponse> {
            serializer = DeleteEntityOperationSerializer()
            deserializer = DeleteEntityOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteEntity"
                hostPrefix = "api."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iottwinmaker"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DeleteEntity-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a scene.
     */
    override suspend fun deleteScene(input: DeleteSceneRequest): DeleteSceneResponse {
        val op = SdkHttpOperation.build<DeleteSceneRequest, DeleteSceneResponse> {
            serializer = DeleteSceneOperationSerializer()
            deserializer = DeleteSceneOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteScene"
                hostPrefix = "api."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iottwinmaker"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DeleteScene-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a workspace.
     */
    override suspend fun deleteWorkspace(input: DeleteWorkspaceRequest): DeleteWorkspaceResponse {
        val op = SdkHttpOperation.build<DeleteWorkspaceRequest, DeleteWorkspaceResponse> {
            serializer = DeleteWorkspaceOperationSerializer()
            deserializer = DeleteWorkspaceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteWorkspace"
                hostPrefix = "api."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iottwinmaker"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DeleteWorkspace-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Run queries to access information from your knowledge graph of entities within individual workspaces.
     */
    override suspend fun executeQuery(input: ExecuteQueryRequest): ExecuteQueryResponse {
        val op = SdkHttpOperation.build<ExecuteQueryRequest, ExecuteQueryResponse> {
            serializer = ExecuteQueryOperationSerializer()
            deserializer = ExecuteQueryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ExecuteQuery"
                hostPrefix = "api."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iottwinmaker"
            }
        )
        val rootSpan = config.tracer.createRootSpan("ExecuteQuery-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves information about a component type.
     */
    override suspend fun getComponentType(input: GetComponentTypeRequest): GetComponentTypeResponse {
        val op = SdkHttpOperation.build<GetComponentTypeRequest, GetComponentTypeResponse> {
            serializer = GetComponentTypeOperationSerializer()
            deserializer = GetComponentTypeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetComponentType"
                hostPrefix = "api."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iottwinmaker"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetComponentType-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves information about an entity.
     */
    override suspend fun getEntity(input: GetEntityRequest): GetEntityResponse {
        val op = SdkHttpOperation.build<GetEntityRequest, GetEntityResponse> {
            serializer = GetEntityOperationSerializer()
            deserializer = GetEntityOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetEntity"
                hostPrefix = "api."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iottwinmaker"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetEntity-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets the pricing plan.
     */
    override suspend fun getPricingPlan(input: GetPricingPlanRequest): GetPricingPlanResponse {
        val op = SdkHttpOperation.build<GetPricingPlanRequest, GetPricingPlanResponse> {
            serializer = GetPricingPlanOperationSerializer()
            deserializer = GetPricingPlanOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetPricingPlan"
                hostPrefix = "api."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iottwinmaker"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetPricingPlan-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets the property values for a component, component type, entity, or workspace.
     *
     * You must specify a value for either `componentName`, `componentTypeId`, `entityId`, or `workspaceId`.
     */
    override suspend fun getPropertyValue(input: GetPropertyValueRequest): GetPropertyValueResponse {
        val op = SdkHttpOperation.build<GetPropertyValueRequest, GetPropertyValueResponse> {
            serializer = GetPropertyValueOperationSerializer()
            deserializer = GetPropertyValueOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetPropertyValue"
                hostPrefix = "data."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iottwinmaker"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetPropertyValue-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves information about the history of a time series property value for a component, component type, entity, or workspace.
     *
     * You must specify a value for `workspaceId`. For entity-specific queries, specify values for `componentName` and `entityId`. For cross-entity quries, specify a value for `componentTypeId`.
     */
    override suspend fun getPropertyValueHistory(input: GetPropertyValueHistoryRequest): GetPropertyValueHistoryResponse {
        val op = SdkHttpOperation.build<GetPropertyValueHistoryRequest, GetPropertyValueHistoryResponse> {
            serializer = GetPropertyValueHistoryOperationSerializer()
            deserializer = GetPropertyValueHistoryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetPropertyValueHistory"
                hostPrefix = "data."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iottwinmaker"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetPropertyValueHistory-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves information about a scene.
     */
    override suspend fun getScene(input: GetSceneRequest): GetSceneResponse {
        val op = SdkHttpOperation.build<GetSceneRequest, GetSceneResponse> {
            serializer = GetSceneOperationSerializer()
            deserializer = GetSceneOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetScene"
                hostPrefix = "api."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iottwinmaker"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetScene-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves information about a workspace.
     */
    override suspend fun getWorkspace(input: GetWorkspaceRequest): GetWorkspaceResponse {
        val op = SdkHttpOperation.build<GetWorkspaceRequest, GetWorkspaceResponse> {
            serializer = GetWorkspaceOperationSerializer()
            deserializer = GetWorkspaceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetWorkspace"
                hostPrefix = "api."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iottwinmaker"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetWorkspace-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists all component types in a workspace.
     */
    override suspend fun listComponentTypes(input: ListComponentTypesRequest): ListComponentTypesResponse {
        val op = SdkHttpOperation.build<ListComponentTypesRequest, ListComponentTypesResponse> {
            serializer = ListComponentTypesOperationSerializer()
            deserializer = ListComponentTypesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListComponentTypes"
                hostPrefix = "api."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iottwinmaker"
            }
        )
        val rootSpan = config.tracer.createRootSpan("ListComponentTypes-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists all entities in a workspace.
     */
    override suspend fun listEntities(input: ListEntitiesRequest): ListEntitiesResponse {
        val op = SdkHttpOperation.build<ListEntitiesRequest, ListEntitiesResponse> {
            serializer = ListEntitiesOperationSerializer()
            deserializer = ListEntitiesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListEntities"
                hostPrefix = "api."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iottwinmaker"
            }
        )
        val rootSpan = config.tracer.createRootSpan("ListEntities-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists all scenes in a workspace.
     */
    override suspend fun listScenes(input: ListScenesRequest): ListScenesResponse {
        val op = SdkHttpOperation.build<ListScenesRequest, ListScenesResponse> {
            serializer = ListScenesOperationSerializer()
            deserializer = ListScenesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListScenes"
                hostPrefix = "api."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iottwinmaker"
            }
        )
        val rootSpan = config.tracer.createRootSpan("ListScenes-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists all tags associated with a resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
                hostPrefix = "api."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iottwinmaker"
            }
        )
        val rootSpan = config.tracer.createRootSpan("ListTagsForResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves information about workspaces in the current account.
     */
    override suspend fun listWorkspaces(input: ListWorkspacesRequest): ListWorkspacesResponse {
        val op = SdkHttpOperation.build<ListWorkspacesRequest, ListWorkspacesResponse> {
            serializer = ListWorkspacesOperationSerializer()
            deserializer = ListWorkspacesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListWorkspaces"
                hostPrefix = "api."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iottwinmaker"
            }
        )
        val rootSpan = config.tracer.createRootSpan("ListWorkspaces-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Adds tags to a resource.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
                hostPrefix = "api."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iottwinmaker"
            }
        )
        val rootSpan = config.tracer.createRootSpan("TagResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Removes tags from a resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
                hostPrefix = "api."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iottwinmaker"
            }
        )
        val rootSpan = config.tracer.createRootSpan("UntagResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates information in a component type.
     */
    override suspend fun updateComponentType(input: UpdateComponentTypeRequest): UpdateComponentTypeResponse {
        val op = SdkHttpOperation.build<UpdateComponentTypeRequest, UpdateComponentTypeResponse> {
            serializer = UpdateComponentTypeOperationSerializer()
            deserializer = UpdateComponentTypeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateComponentType"
                hostPrefix = "api."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iottwinmaker"
            }
        )
        val rootSpan = config.tracer.createRootSpan("UpdateComponentType-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates an entity.
     */
    override suspend fun updateEntity(input: UpdateEntityRequest): UpdateEntityResponse {
        val op = SdkHttpOperation.build<UpdateEntityRequest, UpdateEntityResponse> {
            serializer = UpdateEntityOperationSerializer()
            deserializer = UpdateEntityOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateEntity"
                hostPrefix = "api."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iottwinmaker"
            }
        )
        val rootSpan = config.tracer.createRootSpan("UpdateEntity-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Update the pricing plan.
     */
    override suspend fun updatePricingPlan(input: UpdatePricingPlanRequest): UpdatePricingPlanResponse {
        val op = SdkHttpOperation.build<UpdatePricingPlanRequest, UpdatePricingPlanResponse> {
            serializer = UpdatePricingPlanOperationSerializer()
            deserializer = UpdatePricingPlanOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdatePricingPlan"
                hostPrefix = "api."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iottwinmaker"
            }
        )
        val rootSpan = config.tracer.createRootSpan("UpdatePricingPlan-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates a scene.
     */
    override suspend fun updateScene(input: UpdateSceneRequest): UpdateSceneResponse {
        val op = SdkHttpOperation.build<UpdateSceneRequest, UpdateSceneResponse> {
            serializer = UpdateSceneOperationSerializer()
            deserializer = UpdateSceneOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateScene"
                hostPrefix = "api."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iottwinmaker"
            }
        )
        val rootSpan = config.tracer.createRootSpan("UpdateScene-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates a workspace.
     */
    override suspend fun updateWorkspace(input: UpdateWorkspaceRequest): UpdateWorkspaceResponse {
        val op = SdkHttpOperation.build<UpdateWorkspaceRequest, UpdateWorkspaceResponse> {
            serializer = UpdateWorkspaceOperationSerializer()
            deserializer = UpdateWorkspaceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateWorkspace"
                hostPrefix = "api."
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iottwinmaker"
            }
        )
        val rootSpan = config.tracer.createRootSpan("UpdateWorkspace-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "iottwinmaker")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
