// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iottwinmaker

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.iottwinmaker.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.iottwinmaker.endpoints.EndpointProvider
import aws.sdk.kotlin.services.iottwinmaker.model.*
import aws.sdk.kotlin.services.iottwinmaker.model.BatchPutPropertyValuesRequest
import aws.sdk.kotlin.services.iottwinmaker.model.BatchPutPropertyValuesResponse
import aws.sdk.kotlin.services.iottwinmaker.model.CreateComponentTypeRequest
import aws.sdk.kotlin.services.iottwinmaker.model.CreateComponentTypeResponse
import aws.sdk.kotlin.services.iottwinmaker.model.CreateEntityRequest
import aws.sdk.kotlin.services.iottwinmaker.model.CreateEntityResponse
import aws.sdk.kotlin.services.iottwinmaker.model.CreateSceneRequest
import aws.sdk.kotlin.services.iottwinmaker.model.CreateSceneResponse
import aws.sdk.kotlin.services.iottwinmaker.model.CreateWorkspaceRequest
import aws.sdk.kotlin.services.iottwinmaker.model.CreateWorkspaceResponse
import aws.sdk.kotlin.services.iottwinmaker.model.DeleteComponentTypeRequest
import aws.sdk.kotlin.services.iottwinmaker.model.DeleteComponentTypeResponse
import aws.sdk.kotlin.services.iottwinmaker.model.DeleteEntityRequest
import aws.sdk.kotlin.services.iottwinmaker.model.DeleteEntityResponse
import aws.sdk.kotlin.services.iottwinmaker.model.DeleteSceneRequest
import aws.sdk.kotlin.services.iottwinmaker.model.DeleteSceneResponse
import aws.sdk.kotlin.services.iottwinmaker.model.DeleteWorkspaceRequest
import aws.sdk.kotlin.services.iottwinmaker.model.DeleteWorkspaceResponse
import aws.sdk.kotlin.services.iottwinmaker.model.ExecuteQueryRequest
import aws.sdk.kotlin.services.iottwinmaker.model.ExecuteQueryResponse
import aws.sdk.kotlin.services.iottwinmaker.model.GetComponentTypeRequest
import aws.sdk.kotlin.services.iottwinmaker.model.GetComponentTypeResponse
import aws.sdk.kotlin.services.iottwinmaker.model.GetEntityRequest
import aws.sdk.kotlin.services.iottwinmaker.model.GetEntityResponse
import aws.sdk.kotlin.services.iottwinmaker.model.GetPricingPlanRequest
import aws.sdk.kotlin.services.iottwinmaker.model.GetPricingPlanResponse
import aws.sdk.kotlin.services.iottwinmaker.model.GetPropertyValueHistoryRequest
import aws.sdk.kotlin.services.iottwinmaker.model.GetPropertyValueHistoryResponse
import aws.sdk.kotlin.services.iottwinmaker.model.GetPropertyValueRequest
import aws.sdk.kotlin.services.iottwinmaker.model.GetPropertyValueResponse
import aws.sdk.kotlin.services.iottwinmaker.model.GetSceneRequest
import aws.sdk.kotlin.services.iottwinmaker.model.GetSceneResponse
import aws.sdk.kotlin.services.iottwinmaker.model.GetWorkspaceRequest
import aws.sdk.kotlin.services.iottwinmaker.model.GetWorkspaceResponse
import aws.sdk.kotlin.services.iottwinmaker.model.ListComponentTypesRequest
import aws.sdk.kotlin.services.iottwinmaker.model.ListComponentTypesResponse
import aws.sdk.kotlin.services.iottwinmaker.model.ListEntitiesRequest
import aws.sdk.kotlin.services.iottwinmaker.model.ListEntitiesResponse
import aws.sdk.kotlin.services.iottwinmaker.model.ListScenesRequest
import aws.sdk.kotlin.services.iottwinmaker.model.ListScenesResponse
import aws.sdk.kotlin.services.iottwinmaker.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.iottwinmaker.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.iottwinmaker.model.ListWorkspacesRequest
import aws.sdk.kotlin.services.iottwinmaker.model.ListWorkspacesResponse
import aws.sdk.kotlin.services.iottwinmaker.model.TagResourceRequest
import aws.sdk.kotlin.services.iottwinmaker.model.TagResourceResponse
import aws.sdk.kotlin.services.iottwinmaker.model.UntagResourceRequest
import aws.sdk.kotlin.services.iottwinmaker.model.UntagResourceResponse
import aws.sdk.kotlin.services.iottwinmaker.model.UpdateComponentTypeRequest
import aws.sdk.kotlin.services.iottwinmaker.model.UpdateComponentTypeResponse
import aws.sdk.kotlin.services.iottwinmaker.model.UpdateEntityRequest
import aws.sdk.kotlin.services.iottwinmaker.model.UpdateEntityResponse
import aws.sdk.kotlin.services.iottwinmaker.model.UpdatePricingPlanRequest
import aws.sdk.kotlin.services.iottwinmaker.model.UpdatePricingPlanResponse
import aws.sdk.kotlin.services.iottwinmaker.model.UpdateSceneRequest
import aws.sdk.kotlin.services.iottwinmaker.model.UpdateSceneResponse
import aws.sdk.kotlin.services.iottwinmaker.model.UpdateWorkspaceRequest
import aws.sdk.kotlin.services.iottwinmaker.model.UpdateWorkspaceResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.Url
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.tracing.DefaultTracer
import aws.smithy.kotlin.runtime.tracing.LoggingTraceProbe
import aws.smithy.kotlin.runtime.tracing.Tracer
import aws.smithy.kotlin.runtime.tracing.TracingClientConfig

/**
 * IoT TwinMaker is a service that enables you to build operational digital twins of physical systems. IoT TwinMaker overlays measurements and analysis from real-world sensors, cameras, and enterprise applications so you can create data visualizations to monitor your physical factory, building, or industrial plant. You can use this real-world data to monitor operations and diagnose and repair errors.
 */
public interface IoTTwinMakerClient : SdkClient {

    override val serviceName: String
        get() = "IoTTwinMaker"
    /**
     * IoTTwinMakerClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): IoTTwinMakerClient {
            val config = Config.Builder().apply(block).build()
            return DefaultIoTTwinMakerClient(config)
        }

        public operator fun invoke(config: Config): IoTTwinMakerClient = DefaultIoTTwinMakerClient(config)

        /**
         * Construct a [IoTTwinMakerClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): IoTTwinMakerClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultIoTTwinMakerClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig, TracingClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        override val tracer: Tracer = builder.tracer ?: DefaultTracer(LoggingTraceProbe, "IoTTwinMaker")
        public val useDualStack: Boolean = builder.useDualStack
        public val useFips: Boolean = builder.useFips
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * The endpoint provider used to determine where to make service requests.
             */
            public var endpointProvider: EndpointProvider? = null
            /**
             * A custom endpoint to use when making requests.
             */
            public var endpointUrl: Url? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null
            /**
             * The tracer that is responsible for creating trace spans and wiring them up to a tracing backend (e.g.,
             * a trace probe). By default, this will create a standard tracer that uses the service name for the root
             * trace span and delegates to a logging trace probe (i.e.,
             * `DefaultTracer(LoggingTraceProbe, "<service-name>")`).
             */
            public var tracer: Tracer? = null
            /**
             * Flag to toggle whether to use dual-stack endpoints when making requests.
             */
            public var useDualStack: Boolean = false
            /**
             * Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             */
            public var useFips: Boolean = false

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Sets values for multiple time series properties.
     */
    public suspend fun batchPutPropertyValues(input: BatchPutPropertyValuesRequest): BatchPutPropertyValuesResponse

    /**
     * Creates a component type.
     */
    public suspend fun createComponentType(input: CreateComponentTypeRequest): CreateComponentTypeResponse

    /**
     * Creates an entity.
     */
    public suspend fun createEntity(input: CreateEntityRequest): CreateEntityResponse

    /**
     * Creates a scene.
     */
    public suspend fun createScene(input: CreateSceneRequest): CreateSceneResponse

    /**
     * Creates a workplace.
     */
    public suspend fun createWorkspace(input: CreateWorkspaceRequest): CreateWorkspaceResponse

    /**
     * Deletes a component type.
     */
    public suspend fun deleteComponentType(input: DeleteComponentTypeRequest): DeleteComponentTypeResponse

    /**
     * Deletes an entity.
     */
    public suspend fun deleteEntity(input: DeleteEntityRequest): DeleteEntityResponse

    /**
     * Deletes a scene.
     */
    public suspend fun deleteScene(input: DeleteSceneRequest): DeleteSceneResponse

    /**
     * Deletes a workspace.
     */
    public suspend fun deleteWorkspace(input: DeleteWorkspaceRequest): DeleteWorkspaceResponse

    /**
     * Run queries to access information from your knowledge graph of entities within individual workspaces.
     */
    public suspend fun executeQuery(input: ExecuteQueryRequest): ExecuteQueryResponse

    /**
     * Retrieves information about a component type.
     */
    public suspend fun getComponentType(input: GetComponentTypeRequest): GetComponentTypeResponse

    /**
     * Retrieves information about an entity.
     */
    public suspend fun getEntity(input: GetEntityRequest): GetEntityResponse

    /**
     * Gets the pricing plan.
     */
    public suspend fun getPricingPlan(input: GetPricingPlanRequest = GetPricingPlanRequest {}): GetPricingPlanResponse

    /**
     * Gets the property values for a component, component type, entity, or workspace.
     *
     * You must specify a value for either `componentName`, `componentTypeId`, `entityId`, or `workspaceId`.
     */
    public suspend fun getPropertyValue(input: GetPropertyValueRequest): GetPropertyValueResponse

    /**
     * Retrieves information about the history of a time series property value for a component, component type, entity, or workspace.
     *
     * You must specify a value for `workspaceId`. For entity-specific queries, specify values for `componentName` and `entityId`. For cross-entity quries, specify a value for `componentTypeId`.
     */
    public suspend fun getPropertyValueHistory(input: GetPropertyValueHistoryRequest): GetPropertyValueHistoryResponse

    /**
     * Retrieves information about a scene.
     */
    public suspend fun getScene(input: GetSceneRequest): GetSceneResponse

    /**
     * Retrieves information about a workspace.
     */
    public suspend fun getWorkspace(input: GetWorkspaceRequest): GetWorkspaceResponse

    /**
     * Lists all component types in a workspace.
     */
    public suspend fun listComponentTypes(input: ListComponentTypesRequest): ListComponentTypesResponse

    /**
     * Lists all entities in a workspace.
     */
    public suspend fun listEntities(input: ListEntitiesRequest): ListEntitiesResponse

    /**
     * Lists all scenes in a workspace.
     */
    public suspend fun listScenes(input: ListScenesRequest): ListScenesResponse

    /**
     * Lists all tags associated with a resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Retrieves information about workspaces in the current account.
     */
    public suspend fun listWorkspaces(input: ListWorkspacesRequest = ListWorkspacesRequest {}): ListWorkspacesResponse

    /**
     * Adds tags to a resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes tags from a resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates information in a component type.
     */
    public suspend fun updateComponentType(input: UpdateComponentTypeRequest): UpdateComponentTypeResponse

    /**
     * Updates an entity.
     */
    public suspend fun updateEntity(input: UpdateEntityRequest): UpdateEntityResponse

    /**
     * Update the pricing plan.
     */
    public suspend fun updatePricingPlan(input: UpdatePricingPlanRequest): UpdatePricingPlanResponse

    /**
     * Updates a scene.
     */
    public suspend fun updateScene(input: UpdateSceneRequest): UpdateSceneResponse

    /**
     * Updates a workspace.
     */
    public suspend fun updateWorkspace(input: UpdateWorkspaceRequest): UpdateWorkspaceResponse
}

/**
 * Sets values for multiple time series properties.
 */
public suspend inline fun IoTTwinMakerClient.batchPutPropertyValues(crossinline block: BatchPutPropertyValuesRequest.Builder.() -> Unit): BatchPutPropertyValuesResponse = batchPutPropertyValues(BatchPutPropertyValuesRequest.Builder().apply(block).build())

/**
 * Creates a component type.
 */
public suspend inline fun IoTTwinMakerClient.createComponentType(crossinline block: CreateComponentTypeRequest.Builder.() -> Unit): CreateComponentTypeResponse = createComponentType(CreateComponentTypeRequest.Builder().apply(block).build())

/**
 * Creates an entity.
 */
public suspend inline fun IoTTwinMakerClient.createEntity(crossinline block: CreateEntityRequest.Builder.() -> Unit): CreateEntityResponse = createEntity(CreateEntityRequest.Builder().apply(block).build())

/**
 * Creates a scene.
 */
public suspend inline fun IoTTwinMakerClient.createScene(crossinline block: CreateSceneRequest.Builder.() -> Unit): CreateSceneResponse = createScene(CreateSceneRequest.Builder().apply(block).build())

/**
 * Creates a workplace.
 */
public suspend inline fun IoTTwinMakerClient.createWorkspace(crossinline block: CreateWorkspaceRequest.Builder.() -> Unit): CreateWorkspaceResponse = createWorkspace(CreateWorkspaceRequest.Builder().apply(block).build())

/**
 * Deletes a component type.
 */
public suspend inline fun IoTTwinMakerClient.deleteComponentType(crossinline block: DeleteComponentTypeRequest.Builder.() -> Unit): DeleteComponentTypeResponse = deleteComponentType(DeleteComponentTypeRequest.Builder().apply(block).build())

/**
 * Deletes an entity.
 */
public suspend inline fun IoTTwinMakerClient.deleteEntity(crossinline block: DeleteEntityRequest.Builder.() -> Unit): DeleteEntityResponse = deleteEntity(DeleteEntityRequest.Builder().apply(block).build())

/**
 * Deletes a scene.
 */
public suspend inline fun IoTTwinMakerClient.deleteScene(crossinline block: DeleteSceneRequest.Builder.() -> Unit): DeleteSceneResponse = deleteScene(DeleteSceneRequest.Builder().apply(block).build())

/**
 * Deletes a workspace.
 */
public suspend inline fun IoTTwinMakerClient.deleteWorkspace(crossinline block: DeleteWorkspaceRequest.Builder.() -> Unit): DeleteWorkspaceResponse = deleteWorkspace(DeleteWorkspaceRequest.Builder().apply(block).build())

/**
 * Run queries to access information from your knowledge graph of entities within individual workspaces.
 */
public suspend inline fun IoTTwinMakerClient.executeQuery(crossinline block: ExecuteQueryRequest.Builder.() -> Unit): ExecuteQueryResponse = executeQuery(ExecuteQueryRequest.Builder().apply(block).build())

/**
 * Retrieves information about a component type.
 */
public suspend inline fun IoTTwinMakerClient.getComponentType(crossinline block: GetComponentTypeRequest.Builder.() -> Unit): GetComponentTypeResponse = getComponentType(GetComponentTypeRequest.Builder().apply(block).build())

/**
 * Retrieves information about an entity.
 */
public suspend inline fun IoTTwinMakerClient.getEntity(crossinline block: GetEntityRequest.Builder.() -> Unit): GetEntityResponse = getEntity(GetEntityRequest.Builder().apply(block).build())

/**
 * Gets the pricing plan.
 */
public suspend inline fun IoTTwinMakerClient.getPricingPlan(crossinline block: GetPricingPlanRequest.Builder.() -> Unit): GetPricingPlanResponse = getPricingPlan(GetPricingPlanRequest.Builder().apply(block).build())

/**
 * Gets the property values for a component, component type, entity, or workspace.
 *
 * You must specify a value for either `componentName`, `componentTypeId`, `entityId`, or `workspaceId`.
 */
public suspend inline fun IoTTwinMakerClient.getPropertyValue(crossinline block: GetPropertyValueRequest.Builder.() -> Unit): GetPropertyValueResponse = getPropertyValue(GetPropertyValueRequest.Builder().apply(block).build())

/**
 * Retrieves information about the history of a time series property value for a component, component type, entity, or workspace.
 *
 * You must specify a value for `workspaceId`. For entity-specific queries, specify values for `componentName` and `entityId`. For cross-entity quries, specify a value for `componentTypeId`.
 */
public suspend inline fun IoTTwinMakerClient.getPropertyValueHistory(crossinline block: GetPropertyValueHistoryRequest.Builder.() -> Unit): GetPropertyValueHistoryResponse = getPropertyValueHistory(GetPropertyValueHistoryRequest.Builder().apply(block).build())

/**
 * Retrieves information about a scene.
 */
public suspend inline fun IoTTwinMakerClient.getScene(crossinline block: GetSceneRequest.Builder.() -> Unit): GetSceneResponse = getScene(GetSceneRequest.Builder().apply(block).build())

/**
 * Retrieves information about a workspace.
 */
public suspend inline fun IoTTwinMakerClient.getWorkspace(crossinline block: GetWorkspaceRequest.Builder.() -> Unit): GetWorkspaceResponse = getWorkspace(GetWorkspaceRequest.Builder().apply(block).build())

/**
 * Lists all component types in a workspace.
 */
public suspend inline fun IoTTwinMakerClient.listComponentTypes(crossinline block: ListComponentTypesRequest.Builder.() -> Unit): ListComponentTypesResponse = listComponentTypes(ListComponentTypesRequest.Builder().apply(block).build())

/**
 * Lists all entities in a workspace.
 */
public suspend inline fun IoTTwinMakerClient.listEntities(crossinline block: ListEntitiesRequest.Builder.() -> Unit): ListEntitiesResponse = listEntities(ListEntitiesRequest.Builder().apply(block).build())

/**
 * Lists all scenes in a workspace.
 */
public suspend inline fun IoTTwinMakerClient.listScenes(crossinline block: ListScenesRequest.Builder.() -> Unit): ListScenesResponse = listScenes(ListScenesRequest.Builder().apply(block).build())

/**
 * Lists all tags associated with a resource.
 */
public suspend inline fun IoTTwinMakerClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Retrieves information about workspaces in the current account.
 */
public suspend inline fun IoTTwinMakerClient.listWorkspaces(crossinline block: ListWorkspacesRequest.Builder.() -> Unit): ListWorkspacesResponse = listWorkspaces(ListWorkspacesRequest.Builder().apply(block).build())

/**
 * Adds tags to a resource.
 */
public suspend inline fun IoTTwinMakerClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes tags from a resource.
 */
public suspend inline fun IoTTwinMakerClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates information in a component type.
 */
public suspend inline fun IoTTwinMakerClient.updateComponentType(crossinline block: UpdateComponentTypeRequest.Builder.() -> Unit): UpdateComponentTypeResponse = updateComponentType(UpdateComponentTypeRequest.Builder().apply(block).build())

/**
 * Updates an entity.
 */
public suspend inline fun IoTTwinMakerClient.updateEntity(crossinline block: UpdateEntityRequest.Builder.() -> Unit): UpdateEntityResponse = updateEntity(UpdateEntityRequest.Builder().apply(block).build())

/**
 * Update the pricing plan.
 */
public suspend inline fun IoTTwinMakerClient.updatePricingPlan(crossinline block: UpdatePricingPlanRequest.Builder.() -> Unit): UpdatePricingPlanResponse = updatePricingPlan(UpdatePricingPlanRequest.Builder().apply(block).build())

/**
 * Updates a scene.
 */
public suspend inline fun IoTTwinMakerClient.updateScene(crossinline block: UpdateSceneRequest.Builder.() -> Unit): UpdateSceneResponse = updateScene(UpdateSceneRequest.Builder().apply(block).build())

/**
 * Updates a workspace.
 */
public suspend inline fun IoTTwinMakerClient.updateWorkspace(crossinline block: UpdateWorkspaceRequest.Builder.() -> Unit): UpdateWorkspaceResponse = updateWorkspace(UpdateWorkspaceRequest.Builder().apply(block).build())
